/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.main;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.servicemix.kernel.main.Lock;
import org.apache.servicemix.kernel.main.Statements;

public class DefaultJDBCLock
implements Lock {
    private static final String PROPERTY_LOCK_URL = "servicemix.lock.jdbc.url";
    private static final String PROPERTY_LOCK_JDBC_DRIVER = "servicemix.lock.jdbc.driver";
    private static final String PROPERTY_LOCK_JDBC_USER = "servicemix.lock.jdbc.user";
    private static final String PROPERTY_LOCK_JDBC_PASSWORD = "servicemix.lock.jdbc.password";
    private static final String PROPERTY_LOCK_JDBC_TABLE = "servicemix.lock.jdbc.table";
    private static final String PROPERTY_LOCK_JDBC_CLUSTERNAME = "servicemix.lock.jdbc.clustername";
    private static final String PROPERTY_LOCK_JDBC_TIMEOUT = "servicemix.lock.jdbc.timeout";
    private final Statements statements;
    private Connection lockConnection;
    private String url;
    private String driver;
    private String user;
    private String password;
    private String table;
    private String clusterName;
    private int timeout;

    public DefaultJDBCLock(Properties props) {
        this.url = props.getProperty(PROPERTY_LOCK_URL);
        this.driver = props.getProperty(PROPERTY_LOCK_JDBC_DRIVER);
        this.user = props.getProperty(PROPERTY_LOCK_JDBC_USER);
        this.password = props.getProperty(PROPERTY_LOCK_JDBC_PASSWORD);
        this.table = props.getProperty(PROPERTY_LOCK_JDBC_TABLE);
        this.clusterName = props.getProperty(PROPERTY_LOCK_JDBC_CLUSTERNAME);
        String time = props.getProperty(PROPERTY_LOCK_JDBC_TIMEOUT);
        this.lockConnection = null;
        if (this.table == null) {
            this.table = "SERVICEMIX_LOCK";
        }
        if (this.clusterName == null) {
            this.clusterName = "smx4";
        }
        this.statements = new Statements(this.table, this.clusterName);
        this.timeout = time != null ? Integer.parseInt(time) * 1000 : 10000;
        if (this.user == null) {
            this.user = "";
        }
        if (this.password == null) {
            this.password = "";
        }
        try {
            this.obtainLock();
        }
        catch (Exception e) {
            System.err.println("Error occured while attempting to obtain connection: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void obtainLock() throws Exception {
        Statement statement = null;
        while (true) {
            try {
                this.lockConnection = this.getConnection(this.driver, this.url, this.user, this.password);
                this.lockConnection.setAutoCommit(false);
                this.statements.init(this.lockConnection);
                String sql = this.statements.testLockTableStatus();
                statement = this.lockConnection.prepareStatement(sql);
                statement.execute();
                break;
            }
            catch (Exception e) {
                System.err.println("Could not obtain lock: " + e.getMessage());
                Thread.sleep(this.timeout);
            }
            finally {
                if (null != statement) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e1) {
                        System.err.println("Caught while closing statement: " + e1.getMessage());
                    }
                    statement = null;
                }
            }
            Thread.sleep(this.timeout);
        }
        System.out.println("Connected to data source: " + this.url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock() {
        Statement statement = null;
        boolean result = false;
        try {
            long time;
            int rows;
            if (this.lockConnection.isClosed()) {
                this.obtainLock();
            }
            if ((rows = (statement = this.lockConnection.prepareStatement(this.statements.getLockUpdateStatement(time = System.currentTimeMillis()))).executeUpdate()) == 1) {
                result = true;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to acquire database lock: " + e.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    System.err.println("Failed to close statement" + e);
                }
            }
        }
        return result;
    }

    public void release() throws Exception {
        if (this.lockConnection != null && !this.lockConnection.isClosed()) {
            this.lockConnection.rollback();
            this.lockConnection.close();
        }
    }

    public boolean isAlive() throws Exception {
        if (this.lockConnection == null) {
            return false;
        }
        PreparedStatement statement = null;
        try {
            this.lockConnection.setAutoCommit(false);
            this.statements.init(this.lockConnection);
            String sql = this.statements.testLockTableStatus();
            statement = this.lockConnection.prepareStatement(sql);
            statement.execute();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private Connection getConnection(String driver, String url, String username, String password) throws Exception {
        Connection conn = null;
        Class.forName(driver);
        conn = DriverManager.getConnection(url + ";create=true", username, password);
        return conn;
    }
}

