/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.gogo.runtime.lang.Support;
import org.apache.felix.gogo.runtime.osgi.OSGiShell;
import org.apache.felix.gogo.runtime.shell.CommandProxy;
import org.apache.felix.gogo.runtime.threadio.ThreadIOImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.command.CommandProcessor;
import org.osgi.service.command.Converter;
import org.osgi.service.threadio.ThreadIO;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private OSGiShell shell;
    private ThreadIOImpl threadio;
    private ServiceRegistration shellRegistration;
    private ServiceRegistration threadioRegistration;
    private ServiceTracker converterTracker;
    private ServiceTracker commandTracker;

    public void start(BundleContext context) throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("osgi.command.scope", "log");
        props.put("osgi.command.function", "display");
        this.threadio = new ThreadIOImpl();
        this.threadio.start();
        this.shell = new OSGiShell();
        this.shell.setBundle(context.getBundle());
        this.shell.setThreadio(this.threadio);
        this.shell.setConverter(new Support());
        this.shell.start();
        this.converterTracker = new ServiceTracker(context, Converter.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                Converter converter = (Converter)super.addingService(reference);
                Activator.this.shell.setConverter(converter);
                return converter;
            }

            public void removedService(ServiceReference reference, Object service) {
                Activator.this.shell.unsetConverter((Converter)service);
                super.removedService(reference, service);
            }
        };
        this.converterTracker.open();
        this.commandTracker = new ServiceTracker(context, context.createFilter("(&(osgi.command.scope=*)(osgi.command.function=*))"), null){

            public Object addingService(ServiceReference reference) {
                Object scope = reference.getProperty("osgi.command.scope");
                Object function = reference.getProperty("osgi.command.function");
                ArrayList<CommandProxy> commands = new ArrayList<CommandProxy>();
                if (scope != null && function != null) {
                    if (function.getClass().isArray()) {
                        for (Object f : (Object[])function) {
                            CommandProxy target = new CommandProxy(this.context, reference, f.toString());
                            Activator.this.shell.addCommand(scope.toString(), (Object)target, f.toString());
                            commands.add(target);
                        }
                    } else {
                        CommandProxy target = new CommandProxy(this.context, reference, function.toString());
                        Activator.this.shell.addCommand(scope.toString(), (Object)target, function.toString());
                        commands.add(target);
                    }
                    return commands;
                }
                return null;
            }

            public void removedService(ServiceReference reference, Object service) {
                List commands = (List)service;
                for (Object cmd : commands) {
                    Activator.this.shell.removeCommand(cmd);
                }
                super.removedService(reference, service);
            }
        };
        this.commandTracker.open();
        this.threadioRegistration = context.registerService(ThreadIO.class.getName(), (Object)this.threadio, new Hashtable());
        this.shellRegistration = context.registerService(CommandProcessor.class.getName(), (Object)this.shell, new Hashtable());
    }

    private String getProperty(BundleContext context, String name, String def) {
        String v = context.getProperty(name);
        if (v == null) {
            v = def;
        }
        return v;
    }

    public void stop(BundleContext context) throws Exception {
        this.shellRegistration.unregister();
        this.threadioRegistration.unregister();
        this.threadio.stop();
        this.converterTracker.close();
        this.commandTracker.close();
    }
}

