/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.admin.internal.commands;

import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.karaf.shell.admin.Instance;
import org.apache.felix.karaf.shell.admin.internal.commands.AdminCommandSupport;

@Command(scope="admin", name="list", description="List all existing container instances.")
public class ListCommand
extends AdminCommandSupport {
    @Option(name="-l", aliases={"--location"}, description="Displays the location of the container instances", required=false, multiValued=false)
    boolean location;

    protected Object doExecute() throws Exception {
        Instance[] instances = this.getAdminService().getInstances();
        if (this.location) {
            System.out.println("  Port   State       Pid  Location");
        } else {
            System.out.println("  Port   State       Pid  Name");
        }
        for (Instance instance : instances) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            String s = Integer.toString(instance.getPort());
            for (int i = s.length(); i < 5; ++i) {
                sb.append(' ');
            }
            sb.append(s);
            sb.append("] [");
            String state = instance.getState();
            while (state.length() < "starting".length()) {
                state = state + " ";
            }
            sb.append(state);
            sb.append("] [");
            s = Integer.toString(instance.getPid());
            for (int i = s.length(); i < 5; ++i) {
                sb.append(' ');
            }
            sb.append(s);
            sb.append("] ");
            if (this.location) {
                sb.append(instance.getLocation());
            } else {
                sb.append(instance.getName());
            }
            System.out.println(sb.toString());
        }
        return null;
    }
}

