/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.transaction;

import java.io.File;
import org.apache.geronimo.transaction.log.HOWLLog;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.apache.geronimo.transaction.manager.XidFactoryImpl;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HowlLogFactoryBean
implements FactoryBean,
DisposableBean {
    private HOWLLog howlLog;
    private String logFileDir;
    private XidFactory xidFactory;
    private String bufferClassName = "org.objectweb.howl.log.BlockLogBuffer";
    private int bufferSizeKBytes = 32;
    private boolean checksumEnabled = true;
    private boolean adler32Checksum = true;
    private int flushSleepTimeMilliseconds = 50;
    private String logFileExt = "log";
    private String logFileName = "transaction";
    private int maxBlocksPerFile = -1;
    private int maxLogFiles = 2;
    private int maxBuffers = 0;
    private int minBuffers = 4;
    private int threadsWaitingForceThreshold = -1;
    private File serverBaseDir;

    public HowlLogFactoryBean() {
        String serverDir = System.getProperty("jencks.server.dir", System.getProperty("basedir", System.getProperty("user.dir")));
        this.serverBaseDir = new File(serverDir);
    }

    public Object getObject() throws Exception {
        if (this.howlLog == null) {
            this.howlLog = new HOWLLog(this.bufferClassName, this.bufferSizeKBytes, this.checksumEnabled, this.adler32Checksum, this.flushSleepTimeMilliseconds, this.logFileDir, this.logFileExt, this.logFileName, this.maxBlocksPerFile, this.maxBuffers, this.maxLogFiles, this.minBuffers, this.threadsWaitingForceThreshold, this.xidFactory != null ? this.xidFactory : new XidFactoryImpl(), this.serverBaseDir);
            this.howlLog.doStart();
        }
        return this.howlLog;
    }

    public void destroy() throws Exception {
        if (this.howlLog != null) {
            this.howlLog.doStop();
            this.howlLog = null;
        }
    }

    public Class<?> getObjectType() {
        return TransactionLog.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getBufferClassName() {
        return this.bufferClassName;
    }

    public void setBufferClassName(String bufferClassName) {
        this.bufferClassName = bufferClassName;
    }

    public int getBufferSizeKBytes() {
        return this.bufferSizeKBytes;
    }

    public void setBufferSizeKBytes(int bufferSizeKBytes) {
        this.bufferSizeKBytes = bufferSizeKBytes;
    }

    public boolean isChecksumEnabled() {
        return this.checksumEnabled;
    }

    public void setChecksumEnabled(boolean checksumEnabled) {
        this.checksumEnabled = checksumEnabled;
    }

    public boolean isAdler32Checksum() {
        return this.adler32Checksum;
    }

    public void setAdler32Checksum(boolean adler32Checksum) {
        this.adler32Checksum = adler32Checksum;
    }

    public int getFlushSleepTimeMilliseconds() {
        return this.flushSleepTimeMilliseconds;
    }

    public void setFlushSleepTimeMilliseconds(int flushSleepTimeMilliseconds) {
        this.flushSleepTimeMilliseconds = flushSleepTimeMilliseconds;
    }

    public String getLogFileDir() {
        return this.logFileDir;
    }

    public void setLogFileDir(String logFileDir) {
        this.logFileDir = logFileDir;
    }

    public String getLogFileExt() {
        return this.logFileExt;
    }

    public void setLogFileExt(String logFileExt) {
        this.logFileExt = logFileExt;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    public int getMaxBlocksPerFile() {
        return this.maxBlocksPerFile;
    }

    public void setMaxBlocksPerFile(int maxBlocksPerFile) {
        this.maxBlocksPerFile = maxBlocksPerFile;
    }

    public int getMaxBuffers() {
        return this.maxBuffers;
    }

    public void setMaxBuffers(int maxBuffers) {
        this.maxBuffers = maxBuffers;
    }

    public int getMaxLogFiles() {
        return this.maxLogFiles;
    }

    public void setMaxLogFiles(int maxLogFiles) {
        this.maxLogFiles = maxLogFiles;
    }

    public int getMinBuffers() {
        return this.minBuffers;
    }

    public void setMinBuffers(int minBuffers) {
        this.minBuffers = minBuffers;
    }

    public int getThreadsWaitingForceThreshold() {
        return this.threadsWaitingForceThreshold;
    }

    public void setThreadsWaitingForceThreshold(int threadsWaitingForceThreshold) {
        this.threadsWaitingForceThreshold = threadsWaitingForceThreshold;
    }

    public XidFactory getXidFactory() {
        return this.xidFactory;
    }

    public void setXidFactory(XidFactory xidFactory) {
        this.xidFactory = xidFactory;
    }

    public File getServerBaseDir() {
        return this.serverBaseDir;
    }

    public void setServerBaseDir(File serverBaseDir) {
        this.serverBaseDir = serverBaseDir;
    }
}

