/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.transaction;

import java.util.Collection;
import org.apache.geronimo.transaction.log.HOWLLog;
import org.apache.geronimo.transaction.log.UnrecoverableLog;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.apache.geronimo.transaction.manager.XidFactoryImpl;
import org.apache.servicemix.transaction.GeronimoPlatformTransactionManager;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionManagerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private GeronimoPlatformTransactionManager transactionManager;
    private int defaultTransactionTimeoutSeconds = 600;
    private XidFactory xidFactory;
    private TransactionLog transactionLog;
    private boolean createdTransactionLog;

    public Object getObject() throws Exception {
        if (this.transactionManager == null) {
            this.transactionManager = new GeronimoPlatformTransactionManager(this.defaultTransactionTimeoutSeconds, this.xidFactory, this.transactionLog);
        }
        return this.transactionManager;
    }

    public void destroy() throws Exception {
        if (this.createdTransactionLog && this.transactionLog instanceof HOWLLog) {
            ((HOWLLog)this.transactionLog).doStop();
        }
    }

    public Class<?> getObjectType() {
        return GeronimoPlatformTransactionManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDefaultTransactionTimeoutSeconds(int timeout) {
        this.defaultTransactionTimeoutSeconds = timeout;
    }

    public void setTransactionLog(TransactionLog log) {
        this.transactionLog = log;
    }

    public XidFactory getXidFactory() {
        return this.xidFactory;
    }

    public void setXidFactory(XidFactory xidFactory) {
        this.xidFactory = xidFactory;
    }

    public void setResourceManagers(Collection<?> resourceManagers) {
    }

    public void afterPropertiesSet() throws Exception {
        if (this.transactionLog == null) {
            this.transactionLog = new UnrecoverableLog();
            this.createdTransactionLog = true;
        }
        if (this.xidFactory == null) {
            this.xidFactory = new XidFactoryImpl();
        }
    }
}

