/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import org.apache.felix.karaf.main.Main;
import org.apache.felix.karaf.main.Utils;

public class Bootstrap {
    public static final String FRAMEWORK_PROPERTIES_FILE_NAME = "config.properties";
    public static final String KARAF_FRAMEWORK = "karaf.framework";

    public static void main(String[] args) {
        try {
            Bootstrap.updateClassLoader();
            Main.main(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }

    public static Main launch(String[] args) throws Exception {
        Bootstrap.updateClassLoader();
        Main main = new Main(args);
        main.launch();
        return main;
    }

    private static void updateClassLoader() throws Exception {
        File home = Utils.getKarafHome();
        File base = Utils.getKarafBase(home);
        File file = new File(new File(base, "etc"), FRAMEWORK_PROPERTIES_FILE_NAME);
        if (!file.exists()) {
            file = new File(new File(home, "etc"), FRAMEWORK_PROPERTIES_FILE_NAME);
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        Properties props = new Properties();
        FileInputStream is = new FileInputStream(file);
        props.load(is);
        ((InputStream)is).close();
        String framework = props.getProperty(KARAF_FRAMEWORK);
        if (framework == null) {
            throw new IllegalArgumentException("Property karaf.framework must be set in the etc/config.properties configuration file");
        }
        String bundle = props.getProperty("karaf.framework." + framework);
        if (bundle == null) {
            throw new IllegalArgumentException("Property karaf.framework." + framework + " must be set in the etc/" + FRAMEWORK_PROPERTIES_FILE_NAME + " configuration file");
        }
        File bundleFile = new File(base, bundle);
        if (!bundleFile.exists()) {
            bundleFile = new File(home, bundle);
        }
        if (!bundleFile.exists()) {
            throw new FileNotFoundException(bundleFile.getAbsolutePath());
        }
        URLClassLoader classLoader = (URLClassLoader)Bootstrap.class.getClassLoader();
        Method mth = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        mth.setAccessible(true);
        mth.invoke((Object)classLoader, bundleFile.toURL());
    }
}

