/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.felix.karaf.main.BootstrapLogManager;
import org.apache.felix.karaf.main.Lock;
import org.apache.felix.karaf.main.SimpleFileLock;
import org.apache.felix.karaf.main.StringMap;
import org.apache.felix.karaf.main.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    public static final String SYSTEM_PROPERTIES_FILE_NAME = "system.properties";
    public static final String CONFIG_PROPERTIES_FILE_NAME = "config.properties";
    public static final String STARTUP_PROPERTIES_FILE_NAME = "startup.properties";
    public static final String PROPERTY_AUTO_INSTALL = "karaf.auto.install";
    public static final String PROPERTY_AUTO_START = "karaf.auto.start";
    public static final String PROP_KARAF_HOME = "karaf.home";
    public static final String ENV_KARAF_HOME = "KARAF_HOME";
    public static final String PROP_KARAF_BASE = "karaf.base";
    public static final String ENV_KARAF_BASE = "KARAF_BASE";
    public static final String BUNDLE_LOCATIONS = "bundle.locations";
    public static final String PROPERTY_CONVERT_TO_MAVEN_URL = "karaf.maven.convert";
    public static final String PROPERTY_CM_DIRECTORY = "karaf.cm.dir";
    public static final String PROPERTY_USE_LOCK = "karaf.lock";
    public static final String PROPERTY_LOCK_CLASS = "karaf.lock.class";
    public static final String PROPERTY_LOCK_DELAY = "karaf.lock.delay";
    public static final String PROPERTY_LOCK_LEVEL = "karaf.lock.level";
    public static final String PROPERTY_LOCK_CLASS_DEFAULT = SimpleFileLock.class.getName();
    Logger LOG = Logger.getLogger(this.getClass().getName());
    private File karafHome;
    private File karafBase;
    private Properties configProps = null;
    private Framework framework = null;
    private final String[] args;
    private int exitCode;
    private Lock lock;
    private int defaultStartLevel = 100;
    private int lockStartLevel = 1;
    private int lockDelay = 1000;
    private boolean exiting = false;
    private boolean cmProcessed;
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    public Main(String[] args) {
        this.args = args;
    }

    public void launch() throws Exception {
        this.karafHome = Utils.getKarafHome();
        this.karafBase = Utils.getKarafBase(this.karafHome);
        System.setProperty(PROP_KARAF_HOME, this.karafHome.getPath());
        System.setProperty(PROP_KARAF_BASE, this.karafBase.getPath());
        this.loadSystemProperties();
        this.configProps = this.loadConfigProperties();
        BootstrapLogManager.setProperties(this.configProps);
        this.LOG.addHandler(BootstrapLogManager.getDefaultHandler());
        Main.copySystemProperties(this.configProps);
        Main.processSecurityProperties(this.configProps);
        if (this.configProps.getProperty("org.osgi.framework.storage") == null) {
            File storage = new File(this.karafBase.getPath(), "data/cache");
            storage.mkdirs();
            this.configProps.setProperty("org.osgi.framework.storage", storage.getAbsolutePath());
        }
        try {
            this.defaultStartLevel = Integer.parseInt(this.configProps.getProperty("org.osgi.framework.startlevel.beginning"));
            this.lockStartLevel = Integer.parseInt(this.configProps.getProperty(PROPERTY_LOCK_LEVEL, Integer.toString(this.lockStartLevel)));
            this.lockDelay = Integer.parseInt(this.configProps.getProperty(PROPERTY_LOCK_DELAY, Integer.toString(this.lockDelay)));
            this.configProps.setProperty("org.osgi.framework.startlevel.beginning", Integer.toString(this.lockStartLevel));
            InputStream is = this.getClass().getResourceAsStream("/META-INF/services/" + FrameworkFactory.class.getName());
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String factoryClass = br.readLine();
            br.close();
            FrameworkFactory factory = (FrameworkFactory)this.getClass().getClassLoader().loadClass(factoryClass).newInstance();
            this.framework = factory.newFramework((Map)new StringMap(this.configProps, false));
            this.framework.start();
            this.processAutoProperties(this.framework.getBundleContext());
            new Thread(){

                public void run() {
                    Main.this.lock(Main.this.configProps);
                }
            }.start();
        }
        catch (Exception ex) {
            this.setExitCode(-1);
            throw new Exception("Could not create framework", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(boolean await) throws Exception {
        try {
            if (await) {
                this.framework.waitForStop(0L);
            }
            this.exiting = true;
            if (this.framework.getState() == 32) {
                this.framework.stop();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Main main = new Main(args);
        try {
            main.launch();
            main.destroy(true);
        }
        catch (Throwable ex) {
            System.err.println("Error occured shutting down framework: " + ex);
            ex.printStackTrace();
        }
        finally {
            System.exit(main.getExitCode());
        }
    }

    private static void processSecurityProperties(Properties m_configProps) {
        String prop = m_configProps.getProperty("org.apache.felix.karaf.security.providers");
        if (prop != null) {
            String[] providers;
            for (String provider : providers = prop.split(",")) {
                try {
                    Security.addProvider((Provider)Class.forName(provider).newInstance());
                }
                catch (Throwable t) {
                    System.err.println("Unable to register security provider: " + t);
                }
            }
        }
    }

    private void processAutoProperties(BundleContext context) {
        Bundle b;
        String[] parts;
        String location;
        StringTokenizer st;
        int startLevel;
        boolean convertToMavenUrls = Boolean.parseBoolean(this.configProps.getProperty(PROPERTY_CONVERT_TO_MAVEN_URL, "true"));
        StartLevel sl = (StartLevel)context.getService(context.getServiceReference(StartLevel.class.getName()));
        int ibsl = 60;
        try {
            String str = this.configProps.getProperty("karaf.startlevel.bundle");
            if (str != null) {
                ibsl = Integer.parseInt(str);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        sl.setInitialBundleStartLevel(ibsl);
        for (String string : this.configProps.keySet()) {
            if (!string.startsWith(PROPERTY_AUTO_INSTALL)) continue;
            startLevel = sl.getInitialBundleStartLevel();
            if (!string.equals(PROPERTY_AUTO_INSTALL)) {
                try {
                    startLevel = Integer.parseInt(string.substring(string.lastIndexOf(46) + 1));
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid property: " + string);
                }
            }
            if ((st = new StringTokenizer(this.configProps.getProperty(string), "\" ", true)).countTokens() <= 0) continue;
            location = null;
            do {
                if ((location = Main.nextLocation(st)) == null) continue;
                try {
                    parts = Main.convertToMavenUrlsIfNeeded(location, convertToMavenUrls);
                    b = context.installBundle(parts[0], new URL(parts[1]).openStream());
                    sl.setBundleStartLevel(b, startLevel);
                }
                catch (Exception ex) {
                    System.err.println("Auto-properties install: " + ex);
                }
            } while (location != null);
        }
        for (String string : this.configProps.keySet()) {
            if (!string.startsWith(PROPERTY_AUTO_START)) continue;
            startLevel = sl.getInitialBundleStartLevel();
            if (!string.equals(PROPERTY_AUTO_START)) {
                try {
                    startLevel = Integer.parseInt(string.substring(string.lastIndexOf(46) + 1));
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid property: " + string);
                }
            }
            if ((st = new StringTokenizer(this.configProps.getProperty(string), "\" ", true)).countTokens() <= 0) continue;
            location = null;
            do {
                if ((location = Main.nextLocation(st)) == null) continue;
                try {
                    parts = Main.convertToMavenUrlsIfNeeded(location, convertToMavenUrls);
                    b = context.installBundle(parts[0], new URL(parts[1]).openStream());
                    sl.setBundleStartLevel(b, startLevel);
                }
                catch (Exception ex) {
                    System.err.println("Auto-properties install:" + ex);
                }
            } while (location != null);
        }
        for (String string : this.configProps.keySet()) {
            StringTokenizer st2;
            if (!string.startsWith(PROPERTY_AUTO_START) || (st2 = new StringTokenizer(this.configProps.getProperty(string), "\" ", true)).countTokens() <= 0) continue;
            String location2 = null;
            do {
                if ((location2 = Main.nextLocation(st2)) == null) continue;
                try {
                    String[] parts2 = Main.convertToMavenUrlsIfNeeded(location2, convertToMavenUrls);
                    Bundle b2 = context.installBundle(parts2[0], new URL(parts2[1]).openStream());
                    if (b2 == null) continue;
                    b2.start();
                    this.checkCmProperties(b2);
                }
                catch (Exception ex) {
                    System.err.println("Auto-properties start: " + ex);
                }
            } while (location2 != null);
        }
    }

    private void checkCmProperties(final Bundle b) {
        final String cmDir = (String)this.configProps.get(PROPERTY_CM_DIRECTORY);
        if (this.cmProcessed || cmDir == null) {
            return;
        }
        try {
            final Class ciClass = b.loadClass("org.apache.felix.fileinstall.internal.ConfigInstaller");
            final Class fiClass = b.loadClass("org.apache.felix.fileinstall.internal.FileInstall");
            new Thread(){

                public void run() {
                    for (int i = 0; !Main.this.cmProcessed && i < 100; ++i) {
                        try {
                            Thread.sleep(50L);
                            Method mth = fiClass.getDeclaredMethod("getConfigurationAdmin", Long.TYPE);
                            mth.setAccessible(true);
                            if (mth.invoke(null, 0) == null) continue;
                            Constructor cns = ciClass.getDeclaredConstructor(BundleContext.class);
                            cns.setAccessible(true);
                            Object ci = cns.newInstance(b.getBundleContext());
                            mth = ciClass.getDeclaredMethod("setConfig", File.class);
                            mth.setAccessible(true);
                            Main.this.cmProcessed = true;
                            for (File f : new File(cmDir).listFiles()) {
                                if (!f.getName().endsWith(".cfg")) continue;
                                mth.invoke(ci, f);
                            }
                            continue;
                        }
                        catch (Throwable t) {
                            if (!Main.this.cmProcessed) continue;
                            t.printStackTrace();
                        }
                    }
                }
            }.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String[] convertToMavenUrlsIfNeeded(String location, boolean convertToMavenUrls) {
        String[] parts = location.split("\\|");
        if (convertToMavenUrls) {
            String[] p = parts[1].split("/");
            if (p.length >= 4 && p[p.length - 1].startsWith(p[p.length - 3] + "-" + p[p.length - 2])) {
                Object groupId = null;
                String artifactId = p[p.length - 3];
                String version = p[p.length - 2];
                String artifactIdVersion = artifactId + "-" + version;
                StringBuffer sb = new StringBuffer();
                String classifier = p[p.length - 1].charAt(artifactIdVersion.length()) == '-' ? p[p.length - 1].substring(artifactIdVersion.length() + 1, p[p.length - 1].lastIndexOf(46)) : null;
                String type = p[p.length - 1].substring(p[p.length - 1].lastIndexOf(46) + 1);
                sb.append("mvn:");
                for (int j = 0; j < p.length - 3; ++j) {
                    if (j > 0) {
                        sb.append('.');
                    }
                    sb.append(p[j]);
                }
                sb.append('/').append(artifactId).append('/').append(version);
                if (!"jar".equals(type) || classifier != null) {
                    sb.append('/');
                    if (!"jar".equals(type)) {
                        sb.append(type);
                    }
                    if (classifier != null) {
                        sb.append('/').append(classifier);
                    }
                }
                parts[1] = parts[0];
                parts[0] = sb.toString();
            } else {
                parts[1] = parts[0];
            }
        } else {
            parts[1] = parts[0];
        }
        return parts;
    }

    private static String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuffer tokBuf = new StringBuffer(10);
            String tok = null;
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            while (st.hasMoreTokens() && !exit) {
                tok = st.nextToken(tokenList);
                if (tok.equals("\"")) {
                    boolean bl = inQuote = !inQuote;
                    if (inQuote) {
                        tokenList = "\"";
                        continue;
                    }
                    tokenList = "\" ";
                    continue;
                }
                if (tok.equals(" ")) {
                    if (!tokStarted) continue;
                    retVal = tokBuf.toString();
                    tokStarted = false;
                    tokBuf = new StringBuffer(10);
                    exit = true;
                    continue;
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return retVal;
    }

    private void loadSystemProperties() {
        URL propURL = null;
        try {
            File file = new File(new File(this.karafBase, "etc"), SYSTEM_PROPERTIES_FILE_NAME);
            propURL = file.toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return;
        }
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = propURL.openConnection().getInputStream();
            props.load(is);
            is.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            System.err.println("Main: Error loading system properties from " + propURL);
            System.err.println("Main: " + ex);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return;
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            System.setProperty(name, Main.substVars(props.getProperty(name), name, null, null));
        }
    }

    private Properties loadConfigProperties() throws Exception {
        StringTokenizer st;
        ArrayList<File> bundleDirs = new ArrayList<File>();
        URL configPropURL = null;
        URL startupPropURL = null;
        try {
            File file = new File(new File(this.karafBase, "etc"), CONFIG_PROPERTIES_FILE_NAME);
            configPropURL = file.toURL();
            file = new File(new File(this.karafBase, "etc"), STARTUP_PROPERTIES_FILE_NAME);
            startupPropURL = file.toURL();
            if (this.karafBase.equals(this.karafHome)) {
                bundleDirs.add(new File(this.karafHome, "system"));
            } else {
                bundleDirs.add(new File(this.karafBase, "system"));
                bundleDirs.add(new File(this.karafHome, "system"));
            }
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return null;
        }
        Properties configProps = Main.loadPropertiesFile(configPropURL);
        Properties startupProps = Main.loadPropertiesFile(startupPropURL);
        String locations = configProps.getProperty(BUNDLE_LOCATIONS);
        if (locations != null && (st = new StringTokenizer(locations, "\" ", true)).countTokens() > 0) {
            String location = null;
            do {
                if ((location = Main.nextLocation(st)) == null) continue;
                File f = new File(location);
                if (f.exists() && f.isDirectory()) {
                    bundleDirs.add(f);
                    continue;
                }
                System.err.println("Bundle location " + location + " does not exist or is not a directory.");
            } while (location != null);
        }
        Enumeration<?> e = configProps.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            configProps.setProperty(name, Main.substVars(configProps.getProperty(name), name, null, configProps));
        }
        Main.processConfigurationProperties(configProps, startupProps, bundleDirs);
        return configProps;
    }

    private static Properties loadPropertiesFile(URL configPropURL) throws Exception {
        Properties configProps = new Properties();
        InputStream is = null;
        try {
            is = configPropURL.openConnection().getInputStream();
            configProps.load(is);
            is.close();
        }
        catch (FileNotFoundException ex) {
            if (configPropURL.getFile().lastIndexOf(STARTUP_PROPERTIES_FILE_NAME) != -1) {
                throw ex;
            }
        }
        catch (Exception ex) {
            System.err.println("Error loading config properties from " + configPropURL);
            System.err.println("Main: " + ex);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return null;
        }
        return configProps;
    }

    private static void copySystemProperties(Properties configProps) {
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("felix.") && !key.startsWith("karaf.") && !key.equals("org.osgi.framework.system.packages") && !key.equals("org.osgi.framework.bootdelegation")) continue;
            configProps.setProperty(key, System.getProperty(key));
        }
    }

    private static void processConfigurationProperties(Properties props, Properties startupProps, ArrayList<File> bundleDirs) {
        if (bundleDirs == null) {
            return;
        }
        if ("all".equals(props.getProperty(PROPERTY_AUTO_START, "").trim())) {
            props.remove(PROPERTY_AUTO_START);
            ArrayList<File> jars = new ArrayList<File>();
            for (File file : bundleDirs) {
                Main.findJars(file, jars);
            }
            StringBuffer sb = new StringBuffer();
            for (File jar : jars) {
                try {
                    sb.append("\"").append(jar.toURL().toString()).append("\" ");
                }
                catch (MalformedURLException e) {
                    System.err.print("Ignoring " + jar.toString() + " (" + e + ")");
                }
            }
            props.setProperty(PROPERTY_AUTO_START, sb.toString());
        } else if (STARTUP_PROPERTIES_FILE_NAME.equals(props.getProperty(PROPERTY_AUTO_START, "").trim())) {
            props.remove(PROPERTY_AUTO_START);
            HashMap<Integer, StringBuffer> levels = new HashMap<Integer, StringBuffer>();
            for (String string : startupProps.keySet()) {
                File file = Main.findFile(bundleDirs, string);
                if (file != null) {
                    Integer level;
                    try {
                        level = new Integer(startupProps.getProperty(string).trim());
                    }
                    catch (NumberFormatException e1) {
                        System.err.print("Ignoring " + file.toString() + " (run level must be an integer)");
                        continue;
                    }
                    StringBuffer sb = (StringBuffer)levels.get(level);
                    if (sb == null) {
                        sb = new StringBuffer(256);
                        levels.put(level, sb);
                    }
                    try {
                        sb.append("\"").append(file.toURL().toString()).append("|").append(string).append("\" ");
                    }
                    catch (MalformedURLException e) {
                        System.err.print("Ignoring " + file.toString() + " (" + e + ")");
                    }
                    continue;
                }
                System.err.println("Bundle listed in startup.properties configuration not found: " + string);
            }
            for (Map.Entry entry : levels.entrySet()) {
                props.setProperty("karaf.auto.start." + entry.getKey(), ((StringBuffer)entry.getValue()).toString());
            }
        }
    }

    private static File findFile(ArrayList<File> bundleDirs, String name) {
        for (File bundleDir : bundleDirs) {
            File file = Main.findFile(bundleDir, name);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private static File findFile(File dir, String name) {
        File theFile = new File(dir, name);
        if (theFile.exists() && !theFile.isDirectory()) {
            return theFile;
        }
        for (File file : dir.listFiles()) {
            if (!file.isDirectory()) continue;
            return Main.findFile(file, name);
        }
        return null;
    }

    private static void findJars(File dir, ArrayList<File> jars) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                Main.findJars(file, jars);
                continue;
            }
            if (!file.toString().endsWith(".jar")) continue;
            jars.add(file);
        }
    }

    public static String substVars(String val, String currentKey, Map<String, String> cycleMap, Properties configProps) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 && stopDelim < 0) {
            return val;
        }
        if ((startDelim < 0 || startDelim > stopDelim) && stopDelim >= 0) {
            throw new IllegalArgumentException("stop delimiter with no start delimiter: " + val);
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.getProperty(variable, null) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = Main.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }

    public String[] getArgs() {
        return this.args;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public void lock(Properties props) {
        block9: {
            try {
                if (Boolean.parseBoolean(props.getProperty(PROPERTY_USE_LOCK, "true"))) {
                    String clz = props.getProperty(PROPERTY_LOCK_CLASS, PROPERTY_LOCK_CLASS_DEFAULT);
                    this.lock = (Lock)Class.forName(clz).getConstructor(Properties.class).newInstance(props);
                    boolean lockLogged = false;
                    this.setStartLevel(this.lockStartLevel);
                    while (true) {
                        if (this.lock.lock()) {
                            if (lockLogged) {
                                this.LOG.info("Lock acquired.");
                            }
                            this.setStartLevel(this.defaultStartLevel);
                            while (this.lock.isAlive()) {
                                Thread.sleep(this.lockDelay);
                            }
                            if (this.framework.getState() == 32 && !this.exiting) {
                                this.LOG.info("Lost the lock, stopping this instance ...");
                                this.setStartLevel(this.lockStartLevel);
                            }
                            break block9;
                        }
                        if (!lockLogged) {
                            this.LOG.info("Waiting for the lock ...");
                            lockLogged = true;
                        }
                        Thread.sleep(this.lockDelay);
                    }
                }
                this.setStartLevel(this.defaultStartLevel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void unlock() throws Exception {
        if (this.lock != null) {
            this.lock.release();
        }
    }

    protected void setStartLevel(int level) throws Exception {
        BundleContext ctx = this.framework.getBundleContext();
        ServiceReference[] refs = ctx.getServiceReferences(StartLevel.class.getName(), null);
        StartLevel sl = (StartLevel)ctx.getService(refs[0]);
        sl.setStartLevel(level);
    }
}

