/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.jansi;

import java.io.OutputStream;
import java.io.PrintStream;
import org.fusesource.jansi.AnsiOutputStream;
import org.fusesource.jansi.WindowsAnsiOutputStream;
import org.fusesource.jansi.internal.CLibrary;

public class AnsiConsole {
    private static final PrintStream system_out = System.out;
    public static final PrintStream out = new PrintStream(AnsiConsole.wrapOutputStream(system_out));
    private static int installed;

    public static OutputStream wrapOutputStream(OutputStream system_out) {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            try {
                return new WindowsAnsiOutputStream(system_out);
            }
            catch (Throwable ignore) {
                return new AnsiOutputStream(system_out);
            }
        }
        try {
            int rc = CLibrary.CLIBRARY.isatty(1);
            if (rc == 0) {
                return new AnsiOutputStream(system_out);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return system_out;
    }

    public static PrintStream out() {
        return out;
    }

    public static synchronized void systemInstall() {
        if (++installed == 1) {
            System.setOut(out);
        }
    }

    public static synchronized void systemUninstall() {
        if (--installed == 0) {
            System.setOut(out);
        }
    }
}

