/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.features.command;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.karaf.features.FeaturesService;
import org.apache.felix.karaf.features.Repository;
import org.apache.felix.karaf.features.command.FeaturesCommandSupport;

@Command(scope="features", name="refreshUrl", description="Reloads the list of available features from the repositories.")
public class RefreshUrlCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="urls", description="Repository URLs to reload (leave empty for all)", required=false, multiValued=true)
    List<String> urls;

    protected void doExecute(FeaturesService admin) throws Exception {
        if (this.urls == null || this.urls.isEmpty()) {
            this.urls = new ArrayList<String>();
            for (Repository repo : admin.listRepositories()) {
                this.urls.add(repo.getURI().toString());
            }
        }
        for (String strUri : this.urls) {
            URI uri = new URI(strUri);
            admin.removeRepository(uri);
            admin.addRepository(uri);
        }
    }
}

