/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.deployer.blueprint;

import java.io.File;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.fileinstall.ArtifactTransformer;
import org.apache.felix.karaf.deployer.blueprint.BlueprintTransformer;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BlueprintDeploymentListener
implements ArtifactTransformer {
    private static final Log LOGGER = LogFactory.getLog(BlueprintDeploymentListener.class);
    private DocumentBuilderFactory dbf;

    public boolean canHandle(File artifact) {
        try {
            if (artifact.isFile() && artifact.getName().endsWith(".xml")) {
                Document doc = this.parse(artifact);
                String name = doc.getDocumentElement().getLocalName();
                String uri = doc.getDocumentElement().getNamespaceURI();
                if ("blueprint".equals(name) && "http://www.osgi.org/xmlns/blueprint/v1.0.0".equals(uri)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Unable to parse deployed file " + artifact.getAbsolutePath()), (Throwable)e);
        }
        return false;
    }

    public File transform(File artifact, File tmpDir) {
        try {
            File destFile = new File(tmpDir, artifact.getName() + ".jar");
            FileOutputStream os = new FileOutputStream(destFile);
            BlueprintTransformer.transform(artifact.toURL(), os);
            os.close();
            return destFile;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to build blueprint application bundle", (Throwable)e);
            return null;
        }
    }

    protected Document parse(File artifact) throws Exception {
        if (this.dbf == null) {
            this.dbf = DocumentBuilderFactory.newInstance();
            this.dbf.setNamespaceAware(true);
        }
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        db.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException exception) throws SAXException {
            }

            public void error(SAXParseException exception) throws SAXException {
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        return db.parse(artifact);
    }
}

