/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.management;

import java.util.EventObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Role;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.event.ExchangeListener;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.api.internal.InternalExchange;
import org.apache.servicemix.nmr.management.ExchangeFailedEvent;
import org.apache.servicemix.nmr.management.ManagedEndpoint;
import org.fusesource.commons.management.ManagementStrategy;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementEndpointRegistry
implements ExchangeListener,
InitializingBean {
    private static final transient Log LOG = LogFactory.getLog(ManagementEndpointRegistry.class);
    private ManagementStrategy managementStrategy;
    private Map<String, ManagedEndpoint> endpoints = new ConcurrentHashMap<String, ManagedEndpoint>();

    public ManagementStrategy getManagementAgent() {
        return this.managementStrategy;
    }

    public void setManagementStrategy(ManagementStrategy managementStrategy) {
        this.managementStrategy = managementStrategy;
    }

    public void register(InternalEndpoint endpoint, Map<String, ?> properties) {
        try {
            LOG.info((Object)("Registering endpoint: " + endpoint + " with properties " + properties));
            ManagedEndpoint ep = new ManagedEndpoint(endpoint, properties, this.managementStrategy);
            this.endpoints.put(endpoint.getId(), ep);
            this.managementStrategy.manageObject((Object)ep);
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to register managed endpoint: " + e), (Throwable)e);
        }
    }

    public void unregister(InternalEndpoint endpoint, Map<String, ?> properties) {
        if (endpoint == null) {
            return;
        }
        try {
            LOG.info((Object)("Unregistering endpoint: " + endpoint + " with properties " + properties));
            ManagedEndpoint ep = this.endpoints.remove(endpoint.getId());
            this.managementStrategy.unmanageObject((Object)ep);
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to unregister managed endpoint: " + e), (Throwable)e);
        }
    }

    public void exchangeSent(Exchange exchange) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Sending exchange: " + exchange));
            }
            if (exchange.getStatus() == Status.Active && exchange.getRole() == Role.Consumer && exchange.getOut(false) == null && exchange.getFault(false) == null && exchange instanceof InternalExchange) {
                ManagedEndpoint me;
                String id = ((InternalExchange)exchange).getSource().getId();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Source endpoint: " + id + " (known endpoints: " + this.endpoints + ")"));
                }
                if ((me = this.endpoints.get(id)) == null) {
                    LOG.warn((Object)("No managed endpoint registered with id: " + id));
                } else {
                    me.incrementOutbound();
                }
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Caught exception while processing exchange: " + t), t);
        }
    }

    public void exchangeDelivered(Exchange exchange) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Receiving exchange: " + exchange));
            }
            if (exchange.getStatus() == Status.Active && exchange.getRole() == Role.Provider && exchange.getOut(false) == null && exchange.getFault(false) == null && exchange instanceof InternalExchange) {
                ManagedEndpoint me;
                String id = ((InternalExchange)exchange).getDestination().getId();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Dest endpoint: " + id + " (known endpoints: " + this.endpoints + ")"));
                }
                if ((me = this.endpoints.get(id)) == null) {
                    LOG.warn((Object)("No managed endpoint registered with id: " + id));
                } else {
                    me.incrementInbound();
                }
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Caught exception while processing exchange: " + t), t);
        }
    }

    public void exchangeFailed(Exchange exchange) {
        ExchangeFailedEvent event = new ExchangeFailedEvent(exchange);
        try {
            this.managementStrategy.notify((EventObject)event);
        }
        catch (Exception ex) {
            LOG.warn((Object)"ExchangeFailedEvent notification failed", (Throwable)ex);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.managementStrategy == null) {
            throw new IllegalArgumentException("managementStrategy must not be null");
        }
    }
}

