/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.commands;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.karaf.shell.console.OsgiCommandSupport;

@Command(scope="shell", name="grep", description="Prints lines matching the given pattern")
public class GrepAction
extends OsgiCommandSupport {
    @Argument(index=0, name="pattern", description="Regular expression", required=true, multiValued=false)
    private String regex;
    @Option(name="-n", aliases={"--line-number"}, description="Prefixes each line of output with the line number within its input file.", required=false, multiValued=false)
    private boolean lineNumber;
    @Option(name="-v", aliases={"--invert-match"}, description="Inverts the sense of matching, to select non-matching lines.", required=false, multiValued=false)
    private boolean invertMatch;
    @Option(name="-w", aliases={"--word-regexp"}, description="Selects only those lines containing matches that form whole words.  The test is that the matching substring must either be at  the beginning of the line, or preceded by a non-word constituent character.  Similarly, it must be either at the end of the line or followed by a non-word constituent character.  Word-constituent characters are letters, digits, and the underscore.", required=false, multiValued=false)
    private boolean wordRegexp;
    @Option(name="-x", aliases={"--line-regexp"}, description="Selects only those matches that exactly match the whole line.", required=false, multiValued=false)
    private boolean lineRegexp;
    @Option(name="-i", aliases={"--ignore-case"}, description="Ignores case distinctions in both the PATTERN and the input files.", required=false, multiValued=false)
    private boolean ignoreCase;

    protected Object doExecute() throws Exception {
        String regexp = this.regex;
        if (this.wordRegexp) {
            regexp = "\\b" + regexp + "\\b";
        }
        regexp = this.lineRegexp ? "^" + regexp + "$" : ".*" + regexp + ".*";
        if (this.ignoreCase) {
            regexp = regexp.toUpperCase();
        }
        Pattern p = Pattern.compile(regexp);
        try {
            String line;
            int lineno = 1;
            InputStreamReader r = new InputStreamReader(System.in);
            while ((line = this.readLine(r)) != null) {
                if (!(p.matcher(this.ignoreCase ? line.toUpperCase() : line).matches() ^ this.invertMatch)) continue;
                if (this.lineNumber) {
                    System.out.print(String.format("%6d  ", lineno++));
                }
                System.out.println(line);
                ++lineno;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String readLine(Reader in) throws IOException {
        StringBuffer buf = new StringBuffer();
        while (true) {
            int i;
            if ((i = in.read()) == -1 && buf.length() == 0) {
                throw new IOException("break");
            }
            if (i == -1 || i == 10 || i == 13) {
                return buf.toString();
            }
            buf.append((char)i);
        }
    }
}

