/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.reference;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.xbean.naming.context.ContextUtil;
import org.apache.xbean.naming.reference.SimpleReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingReference
extends SimpleReference {
    private final Object lock = new Object();
    private final String fullName;
    private final Reference reference;
    private final String className;
    private Object value;

    public static Object wrapReference(String fullName, Object value) {
        if (value instanceof Reference && !(value instanceof CachingReference)) {
            return new CachingReference(fullName, (Reference)value);
        }
        return value;
    }

    public static Map<String, Object> wrapReferences(Map<String, Object> bindings) {
        LinkedHashMap<String, Object> newBindings = new LinkedHashMap<String, Object>(bindings);
        for (Map.Entry<String, Object> entry : bindings.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof Reference) || value instanceof CachingReference) continue;
            newBindings.put(name, new CachingReference(name, (Reference)value));
        }
        return newBindings;
    }

    public CachingReference(String fullName, Reference reference) {
        this.fullName = fullName;
        this.reference = reference;
        this.className = reference.getClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getContent() throws NamingException {
        Object object = this.lock;
        synchronized (object) {
            if (this.value == null) {
                this.value = ContextUtil.resolve(this.fullName, this.reference);
            }
            return this.value;
        }
    }

    @Override
    public String getClassName() {
        return this.className;
    }
}

