/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.avalon;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.avalon.framework.logger.Logger;
import org.ops4j.pax.logging.OSGIPaxLoggingManager;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.avalon.AvalonLogger;
import org.osgi.framework.BundleContext;

public class AvalonLogFactory {
    private static PaxLoggingManager m_paxLogging;
    private static Map m_loggers;

    public static void setBundleContext(BundleContext context) {
        m_paxLogging = new OSGIPaxLoggingManager(context);
        Set entrySet = m_loggers.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            AvalonLogger logger = (AvalonLogger)entry.getKey();
            String name = (String)entry.getValue();
            logger.setPaxLoggingManager(m_paxLogging, name);
        }
        m_paxLogging.open();
    }

    public static void release() {
        m_paxLogging.close();
        m_paxLogging.dispose();
    }

    public static Logger getLogger(String name) {
        return AvalonLogFactory.getLogger(null, name);
    }

    public static Logger getLogger(AvalonLogger parent, String name) {
        String newName = parent == null ? name : parent.getName() + "." + name;
        PaxLogger logger = m_paxLogging.getLogger(newName, AvalonLogger.AVALON_FQCN);
        AvalonLogger avalonLogger = new AvalonLogger(logger);
        m_loggers.put(avalonLogger, newName);
        return avalonLogger;
    }

    static {
        m_loggers = Collections.synchronizedMap(new WeakHashMap());
    }
}

