/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.ssh;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.sshd.server.CommandFactory;
import org.osgi.service.command.CommandProcessor;
import org.osgi.service.command.CommandSession;

public class ShellCommandFactory
implements CommandFactory {
    private CommandProcessor commandProcessor;

    public void setCommandProcessor(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public CommandFactory.Command createCommand(String command) {
        return new ShellCommand(command);
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public class ShellCommand
    implements CommandFactory.Command {
        private String command;
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private CommandFactory.ExitCallback callback;

        public ShellCommand(String command) {
            this.command = command;
        }

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(CommandFactory.ExitCallback callback) {
            this.callback = callback;
        }

        public void start() throws IOException {
            try {
                CommandSession session = ShellCommandFactory.this.commandProcessor.createSession(this.in, new PrintStream(this.out), new PrintStream(this.err));
                session.execute((CharSequence)this.command);
            }
            catch (Exception e) {
                try {
                    throw (IOException)new IOException("Unable to start shell").initCause(e);
                }
                catch (Throwable throwable) {
                    ShellCommandFactory.close(new Closeable[]{this.in, this.out, this.err});
                    this.callback.onExit(0);
                    throw throwable;
                }
            }
            ShellCommandFactory.close(new Closeable[]{this.in, this.out, this.err});
            this.callback.onExit(0);
        }
    }
}

