/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.features.management.internal;

import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanRegistrer {
    private MBeanServer mbeanServer;
    private Map<Object, String> mbeans;

    public void setMbeans(Map<Object, String> mbeans) {
        this.mbeans = mbeans;
    }

    public void registerMBeanServer(MBeanServer mbeanServer) throws JMException {
        if (this.mbeanServer != mbeanServer) {
            this.unregisterMBeans();
        }
        this.mbeanServer = mbeanServer;
        this.registerMBeans();
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) throws JMException {
        this.unregisterMBeans();
        this.mbeanServer = null;
    }

    public void init() throws Exception {
        this.registerMBeans();
    }

    protected void registerMBeans() throws JMException {
        if (this.mbeanServer != null && this.mbeans != null) {
            for (Map.Entry<Object, String> entry : this.mbeans.entrySet()) {
                this.mbeanServer.registerMBean(entry.getKey(), new ObjectName(entry.getValue()));
            }
        }
    }

    protected void unregisterMBeans() throws JMException {
        if (this.mbeanServer != null && this.mbeans != null) {
            for (Map.Entry<Object, String> entry : this.mbeans.entrySet()) {
                this.mbeanServer.unregisterMBean(new ObjectName(entry.getValue()));
            }
        }
    }
}

