/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.dependencies.startup;

import java.util.ArrayList;
import java.util.Collection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.osgi.extender.OsgiServiceDependencyFactory;
import org.springframework.osgi.service.importer.DefaultOsgiServiceDependency;
import org.springframework.osgi.service.importer.support.OsgiServiceCollectionProxyFactoryBean;
import org.springframework.osgi.service.importer.support.OsgiServiceProxyFactoryBean;
import org.springframework.util.StringUtils;

public class MandatoryImporterDependencyFactory
implements OsgiServiceDependencyFactory {
    public Collection getServiceDependencies(BundleContext bundleContext, ConfigurableListableBeanFactory beanFactory) throws BeansException, InvalidSyntaxException, BundleException {
        String[] singleBeans = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, (Class)OsgiServiceProxyFactoryBean.class, (boolean)true, (boolean)false);
        String[] collectionBeans = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, (Class)OsgiServiceCollectionProxyFactoryBean.class, (boolean)true, (boolean)false);
        String[] beans = StringUtils.concatenateStringArrays((String[])singleBeans, (String[])collectionBeans);
        ArrayList<DefaultOsgiServiceDependency> beansCollections = new ArrayList<DefaultOsgiServiceDependency>(beans.length);
        for (int i = 0; i < beans.length; ++i) {
            DefaultOsgiServiceDependency dependency;
            OsgiServiceProxyFactoryBean importer;
            String beanName = beans[i].startsWith("&") ? beans[i] : "&" + beans[i];
            SmartFactoryBean reference = (SmartFactoryBean)beanFactory.getBean(beanName);
            if (reference instanceof OsgiServiceProxyFactoryBean) {
                importer = (OsgiServiceProxyFactoryBean)reference;
                dependency = new DefaultOsgiServiceDependency(beanName, importer.getUnifiedFilter(), importer.getCardinality().isMandatory());
            } else {
                importer = (OsgiServiceCollectionProxyFactoryBean)reference;
                dependency = new DefaultOsgiServiceDependency(beanName, importer.getUnifiedFilter(), importer.getCardinality().isMandatory());
            }
            beansCollections.add(dependency);
        }
        return beansCollections;
    }
}

