/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import jline.ConsoleReader;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.future.ConnectFuture;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String host = "localhost";
        int port = 8101;
        String user = "karaf";
        String password = "karaf";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if (args[i].equals("-a")) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-h")) {
                    host = args[++i];
                    continue;
                }
                if (args[i].equals("-u")) {
                    user = args[++i];
                    continue;
                }
                if (args[i].equals("-p")) {
                    password = args[++i];
                    continue;
                }
                if (args[i].equals("--help")) {
                    System.out.println("Apache Felix Karaf client");
                    System.out.println("  -a [port]     specify the port to connect to");
                    System.out.println("  -h [host]     specify the host to connect to");
                    System.out.println("  -u [user]     specify the user name");
                    System.out.println("  -p [password] specify the password");
                    System.out.println("  --help        shows this help message");
                    System.out.println("  [commands]    commands to run");
                    System.out.println("If no commands are specified, the client will be put in an interactive mode");
                    System.exit(0);
                    continue;
                }
                System.err.println("Unknown option: " + args[i]);
                System.err.println("Run with --help for usage");
                System.exit(1);
                continue;
            }
            sb.append(args[i]);
            sb.append(' ');
        }
        SshClient client = null;
        try {
            ClientChannel channel;
            client = SshClient.setUpDefaultClient();
            client.start();
            ConnectFuture future = client.connect(host, port);
            future.await();
            ClientSession session = future.getSession();
            session.authPassword(user, password);
            if (sb.length() > 0) {
                channel = session.createChannel("exec");
                channel.setIn((InputStream)new ByteArrayInputStream(sb.append("\n").toString().getBytes()));
            } else {
                channel = session.createChannel("shell");
                channel.setIn(new ConsoleReader().getInput());
            }
            channel.setOut((OutputStream)System.out);
            channel.setErr((OutputStream)System.err);
            channel.open();
            channel.waitFor(2, 0L);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                client.stop();
            }
            catch (Throwable t) {}
        }
        System.exit(0);
    }
}

