/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.console.jline;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.List;
import jline.Terminal;
import org.apache.felix.karaf.shell.console.Completer;
import org.apache.felix.karaf.shell.console.completer.AggregateCompleter;
import org.apache.felix.karaf.shell.console.jline.Console;
import org.fusesource.jansi.AnsiConsole;
import org.osgi.framework.BundleContext;
import org.osgi.service.command.CommandProcessor;
import org.osgi.service.command.CommandSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleFactory {
    private BundleContext bundleContext;
    private CommandProcessor commandProcessor;
    private List<Completer> completers;
    private Terminal terminal;
    private Console console;
    private boolean start;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public synchronized void registerCommandProcessor(CommandProcessor commandProcessor) throws Exception {
        this.commandProcessor = commandProcessor;
        this.start();
    }

    public synchronized void unregisterCommandProcessor(CommandProcessor commandProcessor) throws Exception {
        this.commandProcessor = null;
        this.stop();
    }

    public void setCompleters(List<Completer> completers) {
        this.completers = completers;
    }

    public void setTerminal(Terminal terminal) {
        this.terminal = terminal;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    protected void start() throws Exception {
        if (this.start) {
            InputStream in = ConsoleFactory.unwrap(System.in);
            PrintStream out = ConsoleFactory.unwrap(System.out);
            PrintStream err = ConsoleFactory.unwrap(System.err);
            Runnable callback = new Runnable(){

                public void run() {
                    try {
                        ConsoleFactory.this.bundleContext.getBundle(0L).stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.console = new Console(this.commandProcessor, in, ConsoleFactory.wrap(out), ConsoleFactory.wrap(err), this.terminal, new AggregateCompleter(this.completers), callback);
            CommandSession session = this.console.getSession();
            session.put("USER", (Object)"karaf");
            session.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
            new Thread((Runnable)this.console, "Karaf Shell Console Thread").start();
        }
    }

    protected void stop() throws Exception {
        if (this.console != null) {
            this.console.close();
        }
    }

    private static PrintStream wrap(PrintStream stream) {
        OutputStream o = AnsiConsole.wrapOutputStream(stream);
        if (o instanceof PrintStream) {
            return (PrintStream)o;
        }
        return new PrintStream(o);
    }

    private static <T> T unwrap(T stream) {
        try {
            Method mth = stream.getClass().getMethod("getRoot", new Class[0]);
            return (T)mth.invoke(stream, new Object[0]);
        }
        catch (Throwable t) {
            return stream;
        }
    }
}

