/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.jansi;

import java.util.ArrayList;

public class Ansi {
    private static final char FIRST_ESC_CHAR = '\u001b';
    private static final char SECOND_ESC_CHAR = '[';

    protected boolean isAttributeAnsi() {
        return false;
    }

    protected boolean isStringBuilderAnsi() {
        return false;
    }

    static void dumpEscapeSequence(StringBuilder builder, char command, Object ... options) {
        builder.append('\u001b');
        builder.append('[');
        int size = options.length;
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                builder.append(';');
            }
            builder.append(options[i]);
        }
        builder.append(command);
    }

    public Ansi cursor(final int x, final int y) {
        return new SimpleAnsi(this){

            public void dump(StringBuilder builder) {
                this.previous.dump(builder);
                1.dumpEscapeSequence(builder, 'H', x, y);
            }
        };
    }

    public Ansi cursorUp(final int y) {
        return new SimpleAnsi(this){

            public void dump(StringBuilder builder) {
                this.previous.dump(builder);
                2.dumpEscapeSequence(builder, 'A', y);
            }
        };
    }

    public Ansi cursorDown(final int y) {
        return new SimpleAnsi(this){

            public void dump(StringBuilder builder) {
                this.previous.dump(builder);
                3.dumpEscapeSequence(builder, 'B', y);
            }
        };
    }

    public Ansi cursorRight(final int x) {
        return new SimpleAnsi(this){

            public void dump(StringBuilder builder) {
                this.previous.dump(builder);
                4.dumpEscapeSequence(builder, 'C', x);
            }
        };
    }

    public Ansi cursorLeft(final int x) {
        return new SimpleAnsi(this){

            public void dump(StringBuilder builder) {
                this.previous.dump(builder);
                5.dumpEscapeSequence(builder, 'D', x);
            }
        };
    }

    public Ansi fg(Color color) {
        AttributeAnsi rc = (AttributeAnsi)(this.isAttributeAnsi() ? this : new AttributeAnsi(this));
        rc.options.add(color.fg());
        return rc;
    }

    public Ansi bg(Color color) {
        AttributeAnsi rc = (AttributeAnsi)(this.isAttributeAnsi() ? this : new AttributeAnsi(this));
        rc.options.add(color.bg());
        return rc;
    }

    public Ansi a(Attribute attribute) {
        AttributeAnsi rc = (AttributeAnsi)(this.isAttributeAnsi() ? this : new AttributeAnsi(this));
        rc.options.add(attribute.value());
        return rc;
    }

    public Ansi a(String value) {
        StringBuilderAnsi rc = (StringBuilderAnsi)(this.isStringBuilderAnsi() ? this : new StringBuilderAnsi(this));
        rc.data.append(value);
        return rc;
    }

    public Ansi a(boolean value) {
        StringBuilderAnsi rc = (StringBuilderAnsi)(this.isStringBuilderAnsi() ? this : new StringBuilderAnsi(this));
        rc.data.append(value);
        return rc;
    }

    public Ansi a(char value) {
        StringBuilderAnsi rc = (StringBuilderAnsi)(this.isStringBuilderAnsi() ? this : new StringBuilderAnsi(this));
        rc.data.append(value);
        return rc;
    }

    public Ansi a(char[] value, int offset, int len) {
        StringBuilderAnsi rc = (StringBuilderAnsi)(this.isStringBuilderAnsi() ? this : new StringBuilderAnsi(this));
        rc.data.append(value, offset, len);
        return rc;
    }

    public Ansi a(char[] value) {
        StringBuilderAnsi rc = (StringBuilderAnsi)(this.isStringBuilderAnsi() ? this : new StringBuilderAnsi(this));
        rc.data.append(value);
        return rc;
    }

    public Ansi a(CharSequence value, int start, int end) {
        StringBuilderAnsi rc = (StringBuilderAnsi)(this.isStringBuilderAnsi() ? this : new StringBuilderAnsi(this));
        rc.data.append(value, start, end);
        return rc;
    }

    public Ansi a(CharSequence value) {
        StringBuilderAnsi rc = (StringBuilderAnsi)(this.isStringBuilderAnsi() ? this : new StringBuilderAnsi(this));
        rc.data.append(value);
        return rc;
    }

    public Ansi a(double value) {
        StringBuilderAnsi rc = (StringBuilderAnsi)(this.isStringBuilderAnsi() ? this : new StringBuilderAnsi(this));
        rc.data.append(value);
        return rc;
    }

    public Ansi a(float value) {
        StringBuilderAnsi rc = (StringBuilderAnsi)(this.isStringBuilderAnsi() ? this : new StringBuilderAnsi(this));
        rc.data.append(value);
        return rc;
    }

    public Ansi a(int value) {
        StringBuilderAnsi rc = (StringBuilderAnsi)(this.isStringBuilderAnsi() ? this : new StringBuilderAnsi(this));
        rc.data.append(value);
        return rc;
    }

    public Ansi a(long value) {
        StringBuilderAnsi rc = (StringBuilderAnsi)(this.isStringBuilderAnsi() ? this : new StringBuilderAnsi(this));
        rc.data.append(value);
        return rc;
    }

    public Ansi a(Object value) {
        StringBuilderAnsi rc = (StringBuilderAnsi)(this.isStringBuilderAnsi() ? this : new StringBuilderAnsi(this));
        rc.data.append(value);
        return rc;
    }

    public Ansi a(StringBuffer value) {
        StringBuilderAnsi rc = (StringBuilderAnsi)(this.isStringBuilderAnsi() ? this : new StringBuilderAnsi(this));
        rc.data.append(value);
        return rc;
    }

    public Ansi reset() {
        return this.a(Attribute.RESET);
    }

    public void dump(StringBuilder builder) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dump(sb);
        return sb.toString();
    }

    public static Ansi ansi() {
        return new Ansi();
    }

    private static final class AttributeAnsi
    extends SimpleAnsi {
        private final ArrayList<Integer> options = new ArrayList(5);

        private AttributeAnsi(Ansi previous) {
            super(previous);
        }

        public void dump(StringBuilder builder) {
            this.previous.dump(builder);
            if (this.options.size() == 1 && this.options.get(0) == 0) {
                builder.append('\u001b');
                builder.append('[');
                builder.append('m');
            } else {
                AttributeAnsi.dumpEscapeSequence(builder, 'm', this.options.toArray());
            }
        }

        protected boolean isAttributeAnsi() {
            return true;
        }
    }

    private static abstract class SimpleAnsi
    extends Ansi {
        protected final Ansi previous;

        private SimpleAnsi(Ansi previous) {
            this.previous = previous;
        }
    }

    private static final class StringBuilderAnsi
    extends Ansi {
        private final Ansi previous;
        private final StringBuilder data = new StringBuilder();

        private StringBuilderAnsi(Ansi previous) {
            this.previous = previous;
        }

        public void dump(StringBuilder builder) {
            this.previous.dump(builder);
            builder.append((CharSequence)this.data);
        }

        protected boolean isStringBuilderAnsi() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Attribute {
        RESET(0, "CONCEAL_OFF"),
        INTENSITY_BOLD(1, "INTENSITY_BOLD"),
        INTENSITY_FAINT(2, "INTENSITY_FAINT"),
        ITALIC(3, "ITALIC"),
        UNDERLINE(4, "UNDERLINE"),
        BLINK_SLOW(5, "BLINK_SLOW"),
        BLINK_FAST(6, "BLINK_FAST"),
        NEGATIVE_ON(7, "NEGATIVE_ON"),
        CONCEAL_ON(8, "CONCEAL_ON"),
        UNDERLINE_DOUBLE(21, "UNDERLINE_DOUBLE"),
        INTENSITY_NORMAL(2, "INTENSITY_NORMAL"),
        UNDERLINE_OFF(24, "UNDERLINE_OFF"),
        BLINK_OFF(25, "BLINK_OFF"),
        NEGATIVE_OFF(27, "NEGATIVE_OFF"),
        CONCEAL_OFF(28, "CONCEAL_OFF");

        private final int value;
        private final String name;

        private Attribute(int index, String name) {
            this.value = index;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int value() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Color {
        BLACK(0, "BLACK"),
        RED(1, "RED"),
        GREEN(2, "GREEN"),
        YELLOW(3, "YELLOW"),
        BLUE(4, "BLUE"),
        MAGENTA(5, "MAGENTA"),
        CYAN(6, "CYAN"),
        WHITE(7, "WHITE");

        private final int value;
        private final String name;

        private Color(int index, String name) {
            this.value = index;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int value() {
            return this.value;
        }

        public int fg() {
            return this.value + 30;
        }

        public int bg() {
            return this.value + 40;
        }
    }
}

