/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.jansi;

import com.sun.jna.Pointer;
import java.io.IOException;
import java.io.OutputStream;
import org.fusesource.jansi.AnsiOutputStream;
import org.fusesource.jansi.internal.Kernel32;
import org.fusesource.jansi.internal.WindowsSupport;

public final class WindowsAnsiOutputStream
extends AnsiOutputStream {
    private static final Pointer console = Kernel32.KERNEL32.GetStdHandle(-11);
    private static final short FOREGROUND_BLACK = 0;
    private static final short FOREGROUND_YELLOW = 6;
    private static final short FOREGROUND_MAGENTA = 5;
    private static final short FOREGROUND_CYAN = 3;
    private static final short FOREGROUND_WHITE = 7;
    private static final short BACKGROUND_BLACK = 0;
    private static final short BACKGROUND_YELLOW = 96;
    private static final short BACKGROUND_MAGENTA = 80;
    private static final short BACKGROUND_CYAN = 48;
    private static final short BACKGROUND_WHITE = 112;
    private static final short[] ANSI_FOREGROUND_COLOR_MAP = new short[]{0, 4, 2, 6, 1, 5, 3, 7};
    private static final short[] ANSI_BACKGROUND_COLOR_MAP = new short[]{0, 64, 32, 96, 16, 80, 48, 112};
    private final Kernel32.CONSOLE_SCREEN_BUFFER_INFO.ByReference info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO.ByReference();
    private boolean negative;

    public WindowsAnsiOutputStream(OutputStream os) throws IOException {
        super(os);
        this.getConsoleInfo();
    }

    private void getConsoleInfo() throws IOException {
        this.out.flush();
        if (Kernel32.KERNEL32.GetConsoleScreenBufferInfo(console, this.info) == 0) {
            throw new IOException("Could not get the screen info: " + WindowsSupport.getLastErrorMessage());
        }
        if (this.negative) {
            this.info.attributes = this.invertAttributeColors(this.info.attributes);
        }
    }

    private void applyAttribute() throws IOException {
        this.out.flush();
        short attributes = this.info.attributes;
        if (this.negative) {
            attributes = this.invertAttributeColors(attributes);
        }
        if (Kernel32.KERNEL32.SetConsoleTextAttribute(console, attributes) == 0) {
            throw new IOException(WindowsSupport.getLastErrorMessage());
        }
    }

    private short invertAttributeColors(short attibutes) {
        int fg = 0xF & attibutes;
        int bg = 240 * attibutes;
        attibutes = (short)(attibutes & 0xFF00 | (fg <<= 8) | (bg >>= 8));
        return attibutes;
    }

    private void applyCursorPosition() throws IOException {
        if (Kernel32.KERNEL32.SetConsoleCursorPosition(console, this.info.cursorPosition.copy()) == 0) {
            throw new IOException(WindowsSupport.getLastErrorMessage());
        }
    }

    protected void processCursorLeft(int count) throws IOException {
        this.getConsoleInfo();
        this.info.cursorPosition.x = (short)Math.max(0, this.info.cursorPosition.x - count);
        this.applyCursorPosition();
    }

    protected void processCursorRight(int count) throws IOException {
        this.getConsoleInfo();
        this.info.cursorPosition.x = (short)Math.min(this.info.maximumWindowSize.x, this.info.cursorPosition.x + count);
        this.applyCursorPosition();
    }

    protected void processCursorDown(int count) throws IOException {
        this.getConsoleInfo();
        this.info.cursorPosition.y = (short)Math.min(this.info.maximumWindowSize.y, this.info.cursorPosition.y + count);
        this.applyCursorPosition();
    }

    protected void processCursorUp(int count) throws IOException {
        this.getConsoleInfo();
        this.info.cursorPosition.y = (short)Math.max(0, this.info.cursorPosition.y - count);
        this.applyCursorPosition();
    }

    protected void processCursorTo(int x, int y) throws IOException {
        this.getConsoleInfo();
        this.info.cursorPosition.y = (short)Math.max(0, Math.min(this.info.maximumWindowSize.y, y - 1));
        this.info.cursorPosition.x = (short)Math.max(0, Math.min(this.info.maximumWindowSize.x, x - 1));
        this.applyCursorPosition();
    }

    protected void processEraseScreen(int eraseOption) {
    }

    protected void processSetForegroundColor(int color) throws IOException {
        this.info.attributes = (short)(this.info.attributes & 0xFFFFFFF8 | ANSI_FOREGROUND_COLOR_MAP[color]);
        this.applyAttribute();
    }

    protected void processSetBackgroundColor(int color) throws IOException {
        this.info.attributes = (short)(this.info.attributes & 0xFFFFFF8F | ANSI_BACKGROUND_COLOR_MAP[color]);
        this.applyAttribute();
    }

    protected void processAttributeRest() throws IOException {
        this.info.attributes = (short)(this.info.attributes & 0xFFFFFF00 | 7 | 0);
        this.applyAttribute();
    }

    protected void processSetAttribute(int attribute) throws IOException {
        switch (attribute) {
            case 1: {
                this.info.attributes = (short)(this.info.attributes | 8);
                this.applyAttribute();
                break;
            }
            case 22: {
                this.info.attributes = (short)(this.info.attributes & 0xFFFFFFF7);
                this.applyAttribute();
                break;
            }
            case 4: {
                this.info.attributes = (short)(this.info.attributes | 0x80);
                this.applyAttribute();
                break;
            }
            case 24: {
                this.info.attributes = (short)(this.info.attributes & 0xFFFFFF7F);
                this.applyAttribute();
                break;
            }
            case 7: {
                this.negative = true;
                this.applyAttribute();
                break;
            }
            case 27: {
                this.negative = false;
                this.applyAttribute();
            }
        }
    }
}

