/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.main;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.apache.felix.karaf.main.Main;

public class BootstrapLogManager {
    private static Handler handler;
    private static final String KARAF_BOOTSTRAP_LOG = "karaf.bootstrap.log";
    private static Properties configProps;

    public static Handler getDefaultHandler() {
        File log;
        Properties props = new Properties();
        String filename = configProps.getProperty(KARAF_BOOTSTRAP_LOG);
        if (filename != null) {
            log = new File(filename);
        } else {
            try {
                props.load(new FileInputStream("../etc/org.ops4j.pax.logging.cfg"));
            }
            catch (IOException e) {
                props.setProperty("log4j.appender.out.file", "${karaf.base}/data/log/karaf.log");
            }
            filename = Main.substVars(props.getProperty("log4j.appender.out.file"), "log4j.appender.out.file", null, null);
            log = new File(filename);
        }
        try {
            handler = new SimpleFileHandler(log);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return handler;
    }

    public static void setProperties(Properties configProps) {
        BootstrapLogManager.configProps = configProps;
    }

    public static class SimpleFileHandler
    extends StreamHandler {
        public SimpleFileHandler(File file) throws IOException {
            this.open(file, true);
        }

        private void open(File logfile, boolean append) throws IOException {
            if (!logfile.getParentFile().exists()) {
                logfile.getParentFile().mkdirs();
            }
            FileOutputStream fout = new FileOutputStream(logfile, append);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            this.setOutputStream(out);
        }

        public synchronized void publish(LogRecord record) {
            if (!this.isLoggable(record)) {
                return;
            }
            super.publish(record);
            this.flush();
        }
    }
}

