/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.felix.gogo.runtime.shell.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pipe
extends Thread {
    static final ThreadLocal<InputStream> tIn = new ThreadLocal();
    static final ThreadLocal<PrintStream> tOut = new ThreadLocal();
    static final ThreadLocal<PrintStream> tErr = new ThreadLocal();
    InputStream in;
    PrintStream out;
    PrintStream err;
    PipedOutputStream pout;
    Closure closure;
    Exception exception;
    Object result;
    List<List<CharSequence>> statements;

    public Pipe(Closure closure, List<List<CharSequence>> statements) {
        super("pipe-" + statements);
        this.closure = closure;
        this.statements = statements;
        this.in = tIn.get();
        this.out = tOut.get();
        this.err = tErr.get();
    }

    public void setIn(InputStream in) {
        this.in = in;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setErr(PrintStream err) {
        this.err = err;
    }

    public Pipe connect(Pipe next) throws IOException {
        next.setOut(this.out);
        next.setErr(this.err);
        this.pout = new PipedOutputStream();
        next.setIn(new PipedInputStream(this.pout));
        this.out = new PrintStream(this.pout);
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block15: {
            tIn.set(this.in);
            tOut.set(this.out);
            tErr.set(this.err);
            this.closure.session.service.threadIO.setStreams(this.in, this.out, this.err);
            for (List<CharSequence> statement : this.statements) {
                this.result = this.closure.executeStatement(statement);
                if (this.result == null || this.pout == null) continue;
                this.out.println(this.closure.session.format(this.result, 0));
            }
            Object var4_4 = null;
            this.out.flush();
            this.closure.session.service.threadIO.close();
            tIn.set(this.in);
            tOut.set(this.out);
            tErr.set(this.err);
            try {
                if (this.in instanceof PipedInputStream) {
                    this.in.close();
                }
                if (this.pout != null) {
                    this.pout.close();
                }
                break block15;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            break block15;
            {
                catch (Exception e) {
                    this.exception = e;
                    Object var4_5 = null;
                    this.out.flush();
                    this.closure.session.service.threadIO.close();
                    tIn.set(this.in);
                    tOut.set(this.out);
                    tErr.set(this.err);
                    try {
                        if (this.in instanceof PipedInputStream) {
                            this.in.close();
                        }
                        if (this.pout != null) {
                            this.pout.close();
                        }
                        break block15;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.out.flush();
                this.closure.session.service.threadIO.close();
                tIn.set(this.in);
                tOut.set(this.out);
                tErr.set(this.err);
                try {
                    if (this.in instanceof PipedInputStream) {
                        this.in.close();
                    }
                    if (this.pout != null) {
                        this.pout.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }
}

