/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.felix.fileinstall.ArtifactListener;
import org.apache.felix.fileinstall.ArtifactTransformer;
import org.apache.felix.fileinstall.internal.Artifact;
import org.apache.felix.fileinstall.internal.FileInstall;
import org.apache.felix.fileinstall.internal.Scanner;
import org.apache.felix.fileinstall.internal.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;

public class DirectoryWatcher
extends Thread {
    public static final String FILENAME = "felix.fileinstall.filename";
    public static final String POLL = "felix.fileinstall.poll";
    public static final String DIR = "felix.fileinstall.dir";
    public static final String DEBUG = "felix.fileinstall.debug";
    public static final String TMPDIR = "felix.fileinstall.tmpdir";
    public static final String FILTER = "felix.fileinstall.filter";
    public static final String START_NEW_BUNDLES = "felix.fileinstall.bundles.new.start";
    File watchedDirectory;
    File tmpDir;
    long poll;
    long debug;
    boolean startBundles;
    String filter;
    BundleContext context;
    String originatingFileName;
    Map currentManagedArtifacts = new HashMap();
    Scanner scanner;
    Set processingFailures = new HashSet();
    Map installationFailures = new HashMap();

    public DirectoryWatcher(Dictionary properties, BundleContext context) {
        super(properties.toString());
        this.context = context;
        this.poll = this.getLong(properties, POLL, 2000L);
        this.debug = this.getLong(properties, DEBUG, -1L);
        this.originatingFileName = (String)properties.get(FILENAME);
        this.watchedDirectory = this.getFile(properties, DIR, new File("./load"));
        this.prepareDir(this.watchedDirectory);
        this.tmpDir = this.getFile(properties, TMPDIR, new File("./tmp"));
        this.startBundles = this.getBoolean(properties, START_NEW_BUNDLES, true);
        this.filter = (String)properties.get(FILTER);
        FilenameFilter flt = this.filter != null && this.filter.length() > 0 ? new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches(DirectoryWatcher.this.filter);
            }
        } : null;
        this.scanner = new Scanner(this.watchedDirectory, flt);
    }

    public void run() {
        this.log("{felix.fileinstall.poll (ms) = " + this.poll + ", " + DIR + " = " + this.watchedDirectory.getAbsolutePath() + ", " + DEBUG + " = " + this.debug + ", " + START_NEW_BUNDLES + " = " + this.startBundles + ", " + TMPDIR + " = " + this.tmpDir + ", " + FILTER + " = " + this.filter + "}", null);
        this.initializeCurrentManagedBundles();
        this.scanner.initialize(this.currentManagedArtifacts.keySet());
        while (!DirectoryWatcher.interrupted()) {
            try {
                Set files = this.scanner.scan();
                if (files == null) {
                    Thread.sleep(this.poll);
                    continue;
                }
                List listeners = FileInstall.getListeners();
                ArrayList<Artifact> deleted = new ArrayList<Artifact>();
                ArrayList<Artifact> modified = new ArrayList<Artifact>();
                ArrayList<Artifact> created = new ArrayList<Artifact>();
                files.addAll(this.processingFailures);
                this.processingFailures.clear();
                Iterator it = files.iterator();
                while (it.hasNext()) {
                    ArtifactListener listener;
                    File file = (File)it.next();
                    boolean exists = file.exists();
                    Artifact artifact = (Artifact)this.currentManagedArtifacts.get(file);
                    if (!exists && artifact != null) {
                        this.deleteJaredDirectory(artifact);
                        this.deleteTransformedFile(artifact);
                        deleted.add(artifact);
                        continue;
                    }
                    File jar = file;
                    if (file.isDirectory()) {
                        this.prepareDir(this.tmpDir);
                        try {
                            jar = new File(this.tmpDir, file.getName() + ".jar");
                            Util.jarDir(file, jar);
                        }
                        catch (IOException e) {
                            this.log("Unable to create jar for: " + file.getAbsolutePath(), e);
                            continue;
                        }
                    }
                    if (exists && artifact != null) {
                        if (artifact.getLastModified() > Util.getLastModified(file)) continue;
                        if (artifact.getListener() == null) {
                            listener = this.findListener(jar, listeners);
                            if (listener == null) {
                                this.processingFailures.add(file);
                                continue;
                            }
                            artifact.setListener(listener);
                        }
                        if (!listeners.contains(artifact.getListener()) || !artifact.getListener().canHandle(jar)) {
                            deleted.add(artifact);
                            artifact = null;
                        } else {
                            this.deleteTransformedFile(artifact);
                            artifact.setJaredDirectory(jar);
                            if (this.transformArtifact(artifact)) {
                                modified.add(artifact);
                                continue;
                            }
                            this.deleteJaredDirectory(artifact);
                            deleted.add(artifact);
                            continue;
                        }
                    }
                    if (!exists || artifact != null) continue;
                    listener = this.findListener(jar, listeners);
                    if (listener == null) {
                        this.processingFailures.add(file);
                        continue;
                    }
                    artifact = new Artifact();
                    artifact.setPath(file);
                    artifact.setJaredDirectory(jar);
                    artifact.setListener(listener);
                    if (this.transformArtifact(artifact)) {
                        created.add(artifact);
                        continue;
                    }
                    this.deleteJaredDirectory(artifact);
                }
                Collection uninstalledBundles = this.uninstall(deleted);
                Collection updatedBundles = this.update(modified);
                Collection installedBundles = this.install(created);
                if (uninstalledBundles.size() > 0 || updatedBundles.size() > 0) {
                    this.refresh();
                }
                if (this.startBundles) {
                    this.startAllBundles();
                    this.start(installedBundles);
                }
                Thread.sleep(this.poll);
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable e) {
                this.log("In main loop, we have serious trouble", e);
            }
        }
    }

    ArtifactListener findListener(File artifact, List listeners) {
        Iterator itL = listeners.iterator();
        while (itL.hasNext()) {
            ArtifactListener listener = (ArtifactListener)itL.next();
            if (!listener.canHandle(artifact)) continue;
            return listener;
        }
        return null;
    }

    boolean transformArtifact(Artifact artifact) {
        if (artifact.getListener() instanceof ArtifactTransformer) {
            this.prepareDir(this.tmpDir);
            try {
                File transformed = ((ArtifactTransformer)artifact.getListener()).transform(artifact.getJaredDirectory(), this.tmpDir);
                if (transformed != null) {
                    artifact.setTransformed(transformed);
                    return true;
                }
            }
            catch (Exception e) {
                this.log("Unable to transform artifact: " + artifact.getPath().getAbsolutePath(), e);
            }
            return false;
        }
        return true;
    }

    private void deleteTransformedFile(Artifact artifact) {
        if (artifact.getTransformed() != null && !artifact.getTransformed().equals(artifact.getPath()) && !artifact.getTransformed().delete()) {
            this.log("Unable to delete transformed artifact: " + artifact.getTransformed().getAbsolutePath(), null);
        }
    }

    private void deleteJaredDirectory(Artifact artifact) {
        if (artifact.getJaredDirectory() != null && !artifact.getJaredDirectory().equals(artifact.getPath()) && !artifact.getJaredDirectory().delete()) {
            this.log("Unable to delete jared artifact: " + artifact.getJaredDirectory().getAbsolutePath(), null);
        }
    }

    private void prepareDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            this.log("Cannot create folder " + dir + ". Is the folder write-protected?", null);
            throw new RuntimeException("Cannot create folder: " + dir);
        }
        if (!dir.isDirectory()) {
            this.log("Cannot use " + dir + " because it's not a directory", null);
            throw new RuntimeException("Cannot start FileInstall using something that is not a directory");
        }
    }

    void log(String message, Throwable e) {
        Util.log(this.context, this.debug, message, e);
    }

    boolean isFragment(Bundle bundle) {
        PackageAdmin padmin = FileInstall.getPackageAdmin();
        if (padmin != null) {
            return padmin.getBundleType(bundle) == 1;
        }
        return false;
    }

    void refresh() {
        PackageAdmin padmin = FileInstall.getPackageAdmin();
        if (padmin != null) {
            padmin.refreshPackages(null);
        }
    }

    long getLong(Dictionary properties, String property, long dflt) {
        String value = (String)properties.get(property);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                this.log(property + " set, but not a long: " + value, null);
            }
        }
        return dflt;
    }

    File getFile(Dictionary properties, String property, File dflt) {
        String value = (String)properties.get(property);
        if (value != null) {
            return new File(value);
        }
        return dflt;
    }

    boolean getBoolean(Dictionary properties, String property, boolean dflt) {
        String value = (String)properties.get(property);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return dflt;
    }

    public void close() {
        this.interrupt();
        try {
            this.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initializeCurrentManagedBundles() {
        Bundle[] bundles = this.context.getBundles();
        String watchedDirPath = this.watchedDirectory.toURI().normalize().getPath();
        for (int i = 0; i < bundles.length; ++i) {
            Artifact artifact = new Artifact();
            artifact.setBundleId(bundles[i].getBundleId());
            artifact.setLastModified(bundles[i].getLastModified());
            artifact.setListener(null);
            String location = bundles[i].getLocation();
            String path = null;
            if (location != null && !location.equals("System Bundle")) {
                URI uri;
                try {
                    uri = new URI(bundles[i].getLocation()).normalize();
                }
                catch (URISyntaxException e) {
                    uri = new File(location).toURI().normalize();
                }
                path = uri.getPath();
            }
            if (path == null) continue;
            artifact.setPath(new File(path));
            int index = path.lastIndexOf(47);
            if (index == -1 || !path.startsWith(watchedDirPath)) continue;
            this.currentManagedArtifacts.put(new File(path), artifact);
        }
    }

    private Collection install(Collection artifacts) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            Bundle bundle = this.install(artifact);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    private Collection uninstall(Collection artifacts) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            Bundle b = this.uninstall(artifact);
            if (b == null) continue;
            bundles.add(b);
        }
        return bundles;
    }

    private Collection update(Collection artifacts) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact e = (Artifact)iter.next();
            Bundle b = this.update(e);
            if (b == null) continue;
            bundles.add(b);
        }
        return bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle install(Artifact artifact) {
        Bundle bundle = null;
        try {
            File path = artifact.getPath();
            if (artifact.getListener() instanceof ArtifactInstaller) {
                ((ArtifactInstaller)artifact.getListener()).install(path);
            } else if (artifact.getListener() instanceof ArtifactTransformer) {
                File transformed = artifact.getTransformed();
                Artifact badArtifact = (Artifact)this.installationFailures.get(artifact.getPath());
                if (badArtifact != null && badArtifact.getLastModified() == artifact.getLastModified()) {
                    return null;
                }
                FileInputStream in = new FileInputStream(transformed != null ? transformed : path);
                try {
                    String location = path.toURI().normalize().toString();
                    bundle = this.context.installBundle(location, (InputStream)in);
                }
                finally {
                    ((InputStream)in).close();
                }
                artifact.setBundleId(bundle.getBundleId());
            }
            artifact.setLastModified(Util.getLastModified(path));
            this.installationFailures.remove(path);
            this.currentManagedArtifacts.put(path, artifact);
            this.log("Installed " + path, null);
        }
        catch (Exception e) {
            this.log("Failed to install artifact: " + artifact.getPath(), e);
            this.installationFailures.put(artifact.getPath(), artifact);
        }
        return bundle;
    }

    private Bundle uninstall(Artifact artifact) {
        Bundle bundle = null;
        try {
            File path = artifact.getPath();
            this.currentManagedArtifacts.remove(path);
            this.deleteTransformedFile(artifact);
            if (artifact.getListener() instanceof ArtifactInstaller) {
                ((ArtifactInstaller)artifact.getListener()).uninstall(path);
            } else if (artifact.getListener() instanceof ArtifactTransformer) {
                bundle = this.context.getBundle(artifact.getBundleId());
                if (bundle == null) {
                    this.log("Failed to uninstall bundle: " + path + " with id: " + artifact.getBundleId() + ". The bundle has already been uninstalled", null);
                    return null;
                }
                bundle.uninstall();
            }
            this.log("Uninstalled " + path, null);
        }
        catch (Exception e) {
            this.log("Failed to uninstall artifact: " + artifact.getPath(), e);
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle update(Artifact artifact) {
        Bundle bundle = null;
        try {
            File path = artifact.getPath();
            if (artifact.getListener() instanceof ArtifactInstaller) {
                ((ArtifactInstaller)artifact.getListener()).update(path);
            } else if (artifact.getListener() instanceof ArtifactTransformer) {
                File transformed = artifact.getTransformed();
                bundle = this.context.getBundle(artifact.getBundleId());
                if (bundle == null) {
                    this.log("Failed to update bundle: " + path + " with ID " + artifact.getBundleId() + ". The bundle has been uninstalled", null);
                    return null;
                }
                FileInputStream in = new FileInputStream(transformed != null ? transformed : path);
                try {
                    bundle.update((InputStream)in);
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            artifact.setLastModified(Util.getLastModified(path));
            this.log("Updated " + path, null);
        }
        catch (Exception e) {
            this.log("Failed to update artifact " + artifact.getPath(), e);
        }
        return bundle;
    }

    private void startAllBundles() {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Iterator it = this.currentManagedArtifacts.values().iterator();
        while (it.hasNext()) {
            Bundle bundle;
            Artifact artifact = (Artifact)it.next();
            if (artifact.getBundleId() <= 0L || (bundle = this.context.getBundle(artifact.getBundleId())) == null || bundle.getState() == 8 || bundle.getState() == 32 || !FileInstall.getStartLevel().isBundlePersistentlyStarted(bundle)) continue;
            bundles.add(bundle);
        }
        this.start(bundles);
    }

    private void start(Collection bundles) {
        Iterator b = bundles.iterator();
        while (b.hasNext()) {
            this.start((Bundle)b.next());
        }
    }

    private void start(Bundle bundle) {
        if (!this.isFragment(bundle)) {
            try {
                bundle.start();
                this.log("Started bundle: " + bundle.getLocation(), null);
            }
            catch (BundleException e) {
                this.log("Error while starting bundle: " + bundle.getLocation(), e);
            }
        }
    }
}

