/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.log;

import java.util.Dictionary;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.karaf.shell.console.OsgiCommandSupport;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="log", name="set", description="Sets the log level.")
public class SetLogLevel
extends OsgiCommandSupport {
    @Argument(index=0, name="level", description="The log level to set (TRACE, DEBUG, INFO, WARN, ERROR or - to unset)", required=true, multiValued=false)
    String level;
    @Argument(index=1, name="logger", description="Logger name or ROOT (default)", required=false, multiValued=false)
    String logger;
    static final String CONFIGURATION_PID = "org.ops4j.pax.logging";
    static final String ROOT_LOGGER_PREFIX = "log4j.rootLogger";
    static final String LOGGER_PREFIX = "log4j.logger.";
    static final String ROOT_LOGGER = "ROOT";
    static final String TRACE = "TRACE";
    static final String DEBUG = "DEBUG";
    static final String INFO = "INFO";
    static final String WARN = "WARN";
    static final String ERROR = "ERROR";
    static final String INHERITED = "-";

    protected Object doExecute() throws Exception {
        if (ROOT_LOGGER.equalsIgnoreCase(this.logger)) {
            this.logger = null;
        }
        if (!(TRACE.equals(this.level) || DEBUG.equals(this.level) || INFO.equals(this.level) || WARN.equals(this.level) || ERROR.equals(this.level) || INHERITED.equals(this.level))) {
            System.err.println("level must be set to TRACE, DEBUG, INFO, WARN or ERROR (or - to unset it)");
            return null;
        }
        if (INHERITED.equals(this.level) && this.logger == null) {
            System.err.println("Can not unset the ROOT logger");
            return null;
        }
        ConfigurationAdmin cfgAdmin = this.getConfigAdmin();
        Configuration cfg = cfgAdmin.getConfiguration(CONFIGURATION_PID, null);
        Dictionary props = cfg.getProperties();
        String logger = this.logger;
        String prop = logger == null ? ROOT_LOGGER_PREFIX : LOGGER_PREFIX + logger;
        String val = (String)props.get(prop);
        if (INHERITED.equals(this.level)) {
            if (val != null) {
                int idx = (val = val.trim()).indexOf(",");
                val = idx > 0 ? val.substring(idx) : null;
            }
        } else if (val == null) {
            val = this.level;
        } else {
            int idx = (val = val.trim()).indexOf(",");
            if (idx == 0) {
                val = this.level + val;
            } else if (idx > 0) {
                val = this.level + val.substring(idx);
            }
        }
        if (val == null) {
            props.remove(prop);
        } else {
            props.put(prop, val);
        }
        cfg.update(props);
        return null;
    }

    protected ConfigurationAdmin getConfigAdmin() {
        ServiceReference ref = this.getBundleContext().getServiceReference(ConfigurationAdmin.class.getName());
        return (ConfigurationAdmin)this.getService(ConfigurationAdmin.class, ref);
    }
}

