/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.admin.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import org.apache.felix.karaf.jpm.Process;
import org.apache.felix.karaf.jpm.ProcessBuilderFactory;
import org.apache.felix.karaf.jpm.impl.ScriptUtils;
import org.apache.felix.karaf.shell.admin.Instance;
import org.apache.felix.karaf.shell.admin.internal.AdminServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceImpl
implements Instance {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceImpl.class);
    private AdminServiceImpl service;
    private String name;
    private String location;
    private Process process;

    public InstanceImpl(AdminServiceImpl service, String name, String location) {
        this.service = service;
        this.name = name;
        this.location = location;
    }

    public void attach(int pid) throws IOException {
        this.checkProcess();
        if (this.process != null) {
            throw new IllegalStateException("Instance already started");
        }
        this.process = ProcessBuilderFactory.newInstance().newBuilder().attach(pid);
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean exists() {
        return new File(this.location).isDirectory();
    }

    public int getPid() {
        this.checkProcess();
        return this.process != null ? this.process.getPid() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        InputStream is = null;
        try {
            File f = new File(this.location, "etc/org.apache.felix.karaf.shell.cfg");
            is = new FileInputStream(f);
            Properties props = new Properties();
            props.load(is);
            String loc = props.getProperty("sshPort");
            int n = Integer.parseInt(loc);
            return n;
        }
        catch (Exception e) {
            int n = 0;
            return n;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePort(int port) throws Exception {
        this.checkProcess();
        if (this.process != null) {
            throw new IllegalStateException("Instance not stopped");
        }
        Properties props = new Properties();
        File f = new File(this.location, "etc/org.apache.felix.karaf.shell.cfg");
        FileInputStream is = new FileInputStream(f);
        try {
            props.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
        props.setProperty("sshPort", Integer.toString(port));
        FileOutputStream os = new FileOutputStream(f);
        try {
            props.store(os, null);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public synchronized void start(String javaOpts) throws Exception {
        this.checkProcess();
        if (this.process != null) {
            throw new IllegalStateException("Instance already started");
        }
        if (javaOpts == null) {
            javaOpts = "-server -Xmx512M -Dcom.sun.management.jmxremote";
        }
        File libDir = new File(System.getProperty("karaf.home"), "lib");
        File[] jars = libDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        StringBuilder classpath = new StringBuilder();
        for (File jar : jars) {
            if (classpath.length() > 0) {
                classpath.append(System.getProperty("path.separator"));
            }
            classpath.append(jar.getCanonicalPath());
        }
        String command = new File(System.getProperty("java.home"), ScriptUtils.isWindows() ? "bin\\java.exe" : "bin/java").getCanonicalPath() + " " + javaOpts + " -Djava.util.logging.config.file=\"" + new File(this.location, "etc/java.util.logging.properties").getCanonicalPath() + "\"" + " -Dkaraf.home=\"" + System.getProperty("karaf.home") + "\"" + " -Dkaraf.base=\"" + new File(this.location).getCanonicalPath() + "\"" + " -Dkaraf.startLocalConsole=false" + " -Dkaraf.startRemoteShell=true" + " -classpath " + classpath.toString() + " org.apache.felix.karaf.main.Bootstrap";
        LOG.debug("Starting instance " + this.name + " with command: " + command);
        this.process = ProcessBuilderFactory.newInstance().newBuilder().directory(new File(this.location)).command(command).start();
        this.service.saveState();
    }

    public synchronized void stop() throws Exception {
        this.checkProcess();
        if (this.process == null) {
            throw new IllegalStateException("Instance not started");
        }
        this.process.destroy();
    }

    public synchronized void destroy() throws Exception {
        this.checkProcess();
        if (this.process != null) {
            throw new IllegalStateException("Instance not stopped");
        }
        InstanceImpl.deleteFile(new File(this.location));
        this.service.forget(this.name);
        this.service.saveState();
    }

    public synchronized String getState() {
        int port = this.getPort();
        if (!this.exists() || port <= 0) {
            return "Error";
        }
        this.checkProcess();
        if (this.process == null) {
            return "Stopped";
        }
        try {
            Socket s = new Socket("localhost", port);
            s.close();
            return "Started";
        }
        catch (Exception exception) {
            return "Starting";
        }
    }

    protected void checkProcess() {
        if (this.process != null) {
            try {
                if (!this.process.isRunning()) {
                    this.process = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static boolean deleteFile(File fileToDelete) {
        if (fileToDelete == null || !fileToDelete.exists()) {
            return true;
        }
        boolean result = true;
        if (fileToDelete.isDirectory()) {
            File[] files = fileToDelete.listFiles();
            if (files == null) {
                result = false;
            } else {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (file.getName().equals(".") || file.getName().equals("..")) continue;
                    if (file.isDirectory()) {
                        result &= InstanceImpl.deleteFile(file);
                        continue;
                    }
                    result &= file.delete();
                }
            }
        }
        return result &= fileToDelete.delete();
    }
}

