/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.deployer.features;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.fileinstall.ArtifactTransformer;
import org.apache.felix.karaf.features.Feature;
import org.apache.felix.karaf.features.FeaturesService;
import org.apache.felix.karaf.features.Repository;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FeatureDeploymentListener
implements ArtifactTransformer,
SynchronousBundleListener {
    public static final String FEATURE_PATH = "org.apache.felix.karaf.shell.features";
    private static final Log LOGGER = LogFactory.getLog(FeatureDeploymentListener.class);
    private DocumentBuilderFactory dbf;
    private FeaturesService featuresService;
    private BundleContext bundleContext;
    private static final String DEFAULT_VERSION = "0.0.0";
    private static final Pattern ARTIFACT_MATCHER = Pattern.compile("(.+)(?:-(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?(?:[^a-zA-Z0-9](.*))?)(?:\\.([^\\.]+))", 32);
    private static final Pattern FUZZY_MODIFIDER = Pattern.compile("(?:\\d+[.-])*(.*)", 32);

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    public FeaturesService getFeaturesService() {
        return this.featuresService;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() throws Exception {
        this.bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            this.bundleChanged(new BundleEvent(1, bundle));
        }
    }

    public void destroy() throws Exception {
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    public boolean canHandle(File artifact) {
        try {
            if (artifact.isFile() && artifact.getName().endsWith(".xml")) {
                Document doc = this.parse(artifact);
                String name = doc.getDocumentElement().getLocalName();
                String uri = doc.getDocumentElement().getNamespaceURI();
                if ("features".equals(name) && (uri == null || "".equals(uri))) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Unable to parse deployed file " + artifact.getAbsolutePath()), (Throwable)e);
        }
        return false;
    }

    public File transform(File artifact, File tmpDir) {
        try {
            File destFile = new File(tmpDir, artifact.getName() + ".jar");
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destFile));
            String name = artifact.getCanonicalPath();
            int idx = name.lastIndexOf(47);
            if (idx >= 0) {
                name = name.substring(idx + 1);
            }
            String[] str = FeatureDeploymentListener.extractNameVersionType(name);
            Manifest m = new Manifest();
            m.getMainAttributes().putValue("Manifest-Version", "2");
            m.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
            m.getMainAttributes().putValue("Bundle-SymbolicName", str[0]);
            m.getMainAttributes().putValue("Bundle-Version", str[1]);
            JarOutputStream out = new JarOutputStream(os);
            ZipEntry e = new ZipEntry("META-INF/MANIFEST.MF");
            out.putNextEntry(e);
            m.write(out);
            out.closeEntry();
            e = new ZipEntry("META-INF/");
            out.putNextEntry(e);
            e = new ZipEntry("META-INF/org.apache.felix.karaf.shell.features/");
            out.putNextEntry(e);
            out.closeEntry();
            e = new ZipEntry("META-INF/org.apache.felix.karaf.shell.features/" + name);
            out.putNextEntry(e);
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(artifact));
            FeatureDeploymentListener.copyInputStream(fis, out);
            ((InputStream)fis).close();
            out.closeEntry();
            out.close();
            ((OutputStream)os).close();
            return destFile;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to build spring application bundle", (Throwable)e);
            return null;
        }
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        try {
            Bundle bundle = bundleEvent.getBundle();
            if (bundleEvent.getType() == 1) {
                Enumeration featuresUrlEnumeration = bundle.findEntries("/META-INF/org.apache.felix.karaf.shell.features/", "*.xml", false);
                while (featuresUrlEnumeration != null && featuresUrlEnumeration.hasMoreElements()) {
                    URL url = (URL)featuresUrlEnumeration.nextElement();
                    this.featuresService.addRepository(url.toURI());
                    for (Repository repo : this.featuresService.listRepositories()) {
                        if (!repo.getURI().equals(url.toURI())) continue;
                        for (Feature f : repo.getFeatures()) {
                            try {
                                this.featuresService.installFeature(f.getName(), f.getVersion());
                            }
                            catch (Exception e) {
                                LOGGER.error((Object)("Unable to install feature: " + f.getName()), (Throwable)e);
                            }
                        }
                    }
                }
            } else if (bundleEvent.getType() == 16) {
                Enumeration featuresUrlEnumeration = bundle.findEntries("/META-INF/org.apache.felix.karaf.shell.features/", "*.xml", false);
                while (featuresUrlEnumeration != null && featuresUrlEnumeration.hasMoreElements()) {
                    URL url = (URL)featuresUrlEnumeration.nextElement();
                    for (Repository repo : this.featuresService.listRepositories()) {
                        if (!repo.getURI().equals(url.toURI())) continue;
                        for (Feature f : repo.getFeatures()) {
                            try {
                                this.featuresService.uninstallFeature(f.getName(), f.getVersion());
                            }
                            catch (Exception e) {
                                LOGGER.error((Object)("Unable to uninstall feature: " + f.getName()), (Throwable)e);
                            }
                        }
                    }
                    this.featuresService.removeRepository(url.toURI());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to install / uninstall feature", (Throwable)e);
        }
    }

    protected Document parse(File artifact) throws Exception {
        if (this.dbf == null) {
            this.dbf = DocumentBuilderFactory.newInstance();
            this.dbf.setNamespaceAware(true);
        }
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        db.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException exception) throws SAXException {
            }

            public void error(SAXParseException exception) throws SAXException {
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        return db.parse(artifact);
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
    }

    public static String[] extractNameVersionType(String url) {
        Matcher m = ARTIFACT_MATCHER.matcher(url);
        if (!m.matches()) {
            return new String[]{url, DEFAULT_VERSION};
        }
        StringBuffer v = new StringBuffer();
        String d1 = m.group(1);
        String d2 = m.group(2);
        String d3 = m.group(3);
        String d4 = m.group(4);
        String d5 = m.group(5);
        String d6 = m.group(6);
        if (d2 != null) {
            v.append(d2);
            if (d3 != null) {
                v.append('.');
                v.append(d3);
                if (d4 != null) {
                    v.append('.');
                    v.append(d4);
                    if (d5 != null) {
                        v.append(".");
                        FeatureDeploymentListener.cleanupModifier(v, d5);
                    }
                } else if (d5 != null) {
                    v.append(".0.");
                    FeatureDeploymentListener.cleanupModifier(v, d5);
                }
            } else if (d5 != null) {
                v.append(".0.0.");
                FeatureDeploymentListener.cleanupModifier(v, d5);
            }
        }
        return new String[]{d1, v.toString(), d6};
    }

    private static void cleanupModifier(StringBuffer result, String modifier) {
        Matcher m = FUZZY_MODIFIDER.matcher(modifier);
        if (m.matches()) {
            modifier = m.group(1);
        }
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') && c != '-') continue;
            result.append(c);
        }
    }
}

