/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.ssh;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jline.Terminal;
import org.apache.felix.karaf.shell.console.Completer;
import org.apache.felix.karaf.shell.console.completer.AggregateCompleter;
import org.apache.felix.karaf.shell.console.jline.Console;
import org.apache.felix.karaf.shell.ssh.SshTerminal;
import org.apache.sshd.server.ShellFactory;
import org.osgi.service.command.CommandProcessor;
import org.osgi.service.command.CommandSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellFactoryImpl
implements ShellFactory {
    private CommandProcessor commandProcessor;
    private List<Completer> completers;

    public void setCommandProcessor(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public void setCompleters(List<Completer> completers) {
        this.completers = completers;
    }

    public ShellFactory.Shell createShell() {
        return new ShellImpl();
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public class ShellImpl
    implements ShellFactory.Shell {
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ShellFactory.ExitCallback callback;
        private boolean closed;

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(ShellFactory.ExitCallback callback) {
            this.callback = callback;
        }

        public void start(ShellFactory.Environment env) throws IOException {
            try {
                Console console = new Console(ShellFactoryImpl.this.commandProcessor, this.in, new PrintStream(this.out), new PrintStream(this.err), (Terminal)new SshTerminal(env), (Completer)new AggregateCompleter((Collection)ShellFactoryImpl.this.completers), new Runnable(){

                    public void run() {
                        ShellImpl.this.destroy();
                    }
                });
                CommandSession session = console.getSession();
                session.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
                for (Map.Entry e : env.getEnv().entrySet()) {
                    session.put((String)e.getKey(), e.getValue());
                }
                new Thread((Runnable)console).start();
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unable to start shell").initCause(e);
            }
        }

        public void destroy() {
            if (!this.closed) {
                this.closed = true;
                ShellFactoryImpl.close(new Closeable[]{this.in, this.out, this.err});
                this.callback.onExit(0);
            }
        }
    }
}

