/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.naming;

import java.lang.reflect.Field;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import org.apache.servicemix.naming.InitialContextFactoryWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiInitialContextFactoryBuilder
extends ServiceTracker
implements InitialContextFactoryBuilder {
    private Context osgiContext;

    public OSGiInitialContextFactoryBuilder(BundleContext bundleContext, Context osgiContext) throws NamingException {
        super(bundleContext, InitialContextFactoryBuilder.class.getName(), null);
        this.open();
        this.osgiContext = osgiContext;
        NamingManager.setInitialContextFactoryBuilder(this);
    }

    public void destroy() {
        this.close();
        try {
            for (Field field : NamingManager.class.getDeclaredFields()) {
                if (!InitialContextFactoryBuilder.class.equals(field.getType())) continue;
                field.setAccessible(true);
                field.set(null, null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> env) throws NamingException {
        String className;
        InitialContextFactory factory = null;
        InitialContextFactoryBuilder factoryBuilder = (InitialContextFactoryBuilder)this.getService();
        if (factoryBuilder != null) {
            factory = factoryBuilder.createInitialContextFactory(env);
        }
        if (factory == null && env != null && (className = (String)env.get("java.naming.factory.initial")) != null) {
            try {
                factory = (InitialContextFactory)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                NoInitialContextException ne = new NoInitialContextException("Cannot instantiate class: " + className);
                ne.setRootCause(e);
                throw ne;
            }
        }
        if (factory == null) {
            NoInitialContextException ne = new NoInitialContextException("Need to specify class name in environment or system property, or as an applet parameter, or in an application resource file:  java.naming.factory.initial");
            throw ne;
        }
        return new InitialContextFactoryWrapper(factory, this.osgiContext);
    }
}

