/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.jaas.modules.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.karaf.jaas.modules.RolePrincipal;
import org.apache.felix.karaf.jaas.modules.UserPrincipal;

public class PropertiesLoginModule
implements LoginModule {
    private static final String USER_FILE = "users";
    private static final Log LOG = LogFactory.getLog(PropertiesLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean debug;
    private String usersFile;
    private String user;
    private Set principals = new HashSet();

    public void initialize(Subject sub, CallbackHandler handler, Map sharedState, Map options) {
        this.subject = sub;
        this.callbackHandler = handler;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        this.usersFile = (String)options.get(USER_FILE) + "";
        if (this.debug) {
            LOG.debug((Object)("Initialized debug=" + this.debug + " usersFile=" + this.usersFile));
        }
    }

    public boolean login() throws LoginException {
        String userInfos;
        Properties users = new Properties();
        File f = new File(this.usersFile);
        try {
            users.load(new FileInputStream(f));
        }
        catch (IOException ioe) {
            throw new LoginException("Unable to load user properties file " + f);
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        if ((userInfos = (String)users.get(this.user)) == null) {
            throw new FailedLoginException("User does not exist");
        }
        String[] infos = userInfos.split(",");
        if (!new String(tmpPassword).equals(infos[0])) {
            throw new FailedLoginException("Password does not match");
        }
        this.principals = new HashSet();
        this.principals.add(new UserPrincipal(this.user));
        for (int i = 1; i < infos.length; ++i) {
            this.principals.add(new RolePrincipal(infos[i]));
        }
        users.clear();
        if (this.debug) {
            LOG.debug((Object)("login " + this.user));
        }
        return true;
    }

    public boolean commit() throws LoginException {
        this.subject.getPrincipals().addAll(this.principals);
        this.clear();
        if (this.debug) {
            LOG.debug((Object)"commit");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            LOG.debug((Object)"abort");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        if (this.debug) {
            LOG.debug((Object)"logout");
        }
        return true;
    }

    private void clear() {
        this.user = null;
    }
}

