/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.features.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.felix.karaf.features.Feature;
import org.apache.felix.karaf.features.Repository;
import org.apache.felix.karaf.features.internal.FeatureImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RepositoryImpl
implements Repository {
    private int unnamedRepoId = 0;
    private String name;
    private URI uri;
    private List<Feature> features;
    private List<URI> repositories;

    public RepositoryImpl(URI uri) {
        this.uri = uri;
    }

    public String getName() {
        return this.name;
    }

    public URI getURI() {
        return this.uri;
    }

    public URI[] getRepositories() throws Exception {
        if (this.repositories == null) {
            this.load();
        }
        return this.repositories.toArray(new URI[this.repositories.size()]);
    }

    public Feature[] getFeatures() throws Exception {
        if (this.features == null) {
            this.load();
        }
        return this.features.toArray(new Feature[this.features.size()]);
    }

    public void load() throws IOException {
        try {
            this.repositories = new ArrayList<URI>();
            this.features = new ArrayList<Feature>();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            URLConnection conn = this.uri.toURL().openConnection();
            conn.setDefaultUseCaches(false);
            Document doc = factory.newDocumentBuilder().parse(conn.getInputStream());
            String temp = doc.getDocumentElement().getAttribute("name");
            this.name = "".equals(temp) ? "repo-" + String.valueOf(this.unnamedRepoId++) : temp;
            if (this.uri.toString().startsWith("bundle")) {
                this.name = this.name + "*";
            }
            NodeList nodes = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element e;
                Node node = nodes.item(i);
                if (!(node instanceof Element)) continue;
                if ("repository".equals(node.getNodeName())) {
                    e = (Element)nodes.item(i);
                    this.repositories.add(new URI(e.getTextContent()));
                    continue;
                }
                if (!"feature".equals(node.getNodeName())) continue;
                e = (Element)nodes.item(i);
                String name = e.getAttribute("name");
                String version = e.getAttribute("version");
                FeatureImpl f = version != null && version.length() > 0 ? new FeatureImpl(name, version) : new FeatureImpl(name);
                NodeList featureNodes = e.getElementsByTagName("feature");
                for (int j = 0; j < featureNodes.getLength(); ++j) {
                    Element b = (Element)featureNodes.item(j);
                    String dependencyFeatureVersion = b.getAttribute("version");
                    if (dependencyFeatureVersion != null && dependencyFeatureVersion.length() > 0) {
                        f.addDependency(new FeatureImpl(b.getTextContent(), dependencyFeatureVersion));
                        continue;
                    }
                    f.addDependency(new FeatureImpl(b.getTextContent()));
                }
                NodeList configNodes = e.getElementsByTagName("config");
                for (int j = 0; j < configNodes.getLength(); ++j) {
                    Element c = (Element)configNodes.item(j);
                    String cfgName = c.getAttribute("name");
                    String data = c.getTextContent();
                    Properties properties = new Properties();
                    properties.load(new ByteArrayInputStream(data.getBytes()));
                    this.interpolation(properties);
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    for (Object key : properties.keySet()) {
                        String n = key.toString();
                        hashtable.put(n, properties.getProperty(n));
                    }
                    f.addConfig(cfgName, hashtable);
                }
                NodeList bundleNodes = e.getElementsByTagName("bundle");
                for (int j = 0; j < bundleNodes.getLength(); ++j) {
                    Element b = (Element)bundleNodes.item(j);
                    f.addBundle(b.getTextContent());
                }
                this.features.add(f);
            }
        }
        catch (SAXException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException(e.getMessage() + " : " + this.uri).initCause(e);
        }
        catch (IllegalArgumentException e) {
            throw (IOException)new IOException(e.getMessage() + " : " + this.uri).initCause(e);
        }
    }

    protected void interpolation(Properties properties) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = properties.getProperty(key);
            Matcher matcher = Pattern.compile("\\$\\{([^}]+)\\}").matcher(val);
            while (matcher.find()) {
                String rep = System.getProperty(matcher.group(1));
                if (rep == null) continue;
                val = val.replace(matcher.group(0), rep);
                matcher.reset(val);
            }
            properties.put(key, val);
        }
    }
}

