/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth;

import java.io.IOException;
import org.apache.sshd.client.UserAuth;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthPassword
implements UserAuth {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public UserAuthPassword(ClientSessionImpl session, String username, String password) throws IOException {
        this.log.info("Send SSH_MSG_USERAUTH_REQUEST for password");
        Buffer buffer = session.createBuffer(SshConstants.Message.SSH_MSG_USERAUTH_REQUEST);
        buffer.putString(username);
        buffer.putString("ssh-connection");
        buffer.putString("password");
        buffer.putByte((byte)0);
        buffer.putString(password);
        session.writePacket(buffer);
    }

    public UserAuth.Result next(Buffer buffer) throws IOException {
        SshConstants.Message cmd = buffer.getCommand();
        this.log.info("Received {}", (Object)cmd);
        if (cmd == SshConstants.Message.SSH_MSG_USERAUTH_SUCCESS) {
            return UserAuth.Result.Success;
        }
        if (cmd == SshConstants.Message.SSH_MSG_USERAUTH_FAILURE) {
            return UserAuth.Result.Failure;
        }
        return UserAuth.Result.Continued;
    }
}

