/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.channel.WindowClosedException;
import org.apache.sshd.common.util.Buffer;
import org.slf4j.Logger;

public class ChannelOutputStream
extends OutputStream {
    private final AbstractChannel channel;
    private final Window remoteWindow;
    private final Logger log;
    private final SshConstants.Message cmd;
    private final byte[] b = new byte[1];
    private Buffer buffer;
    private boolean closed;
    private int bufferLength;

    public ChannelOutputStream(AbstractChannel channel, Window remoteWindow, Logger log, SshConstants.Message cmd) {
        this.channel = channel;
        this.remoteWindow = remoteWindow;
        this.log = log;
        this.cmd = cmd;
        this.newBuffer();
    }

    public synchronized void write(int w) throws IOException {
        this.b[0] = (byte)w;
        this.write(this.b, 0, 1);
    }

    public synchronized void write(byte[] buf, int s, int l) throws IOException {
        if (this.closed) {
            throw new SshException("Already closed");
        }
        this.buffer.putRawBytes(buf, s, l);
        this.bufferLength += l;
    }

    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new SshException("Already closed");
        }
        try {
            while (this.bufferLength > 0) {
                Buffer buf = this.buffer;
                int total = this.bufferLength;
                int length = Math.min(Math.min(this.remoteWindow.waitForSpace(), total), this.remoteWindow.getPacketSize());
                int pos = buf.wpos();
                buf.wpos(this.cmd == SshConstants.Message.SSH_MSG_CHANNEL_EXTENDED_DATA ? 14 : 10);
                buf.putInt(length);
                buf.wpos(buf.wpos() + length);
                this.newBuffer();
                if (total > length) {
                    this.buffer.putRawBytes(buf.array(), pos - (total - length), total - length);
                    this.bufferLength = total - length;
                }
                this.remoteWindow.waitAndConsume(length);
                this.log.debug("Send {} on channel {}", (Object)this.cmd, (Object)this.channel.getId());
                this.channel.getSession().writePacket(buf);
            }
        }
        catch (WindowClosedException e) {
            this.closed = true;
            throw e;
        }
        catch (SshException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
        finally {
            this.newBuffer();
        }
    }

    public synchronized void close() throws IOException {
        this.closed = true;
    }

    private void newBuffer() {
        this.buffer = this.channel.getSession().createBuffer(this.cmd);
        this.buffer.putInt(this.channel.getRecipient());
        if (this.cmd == SshConstants.Message.SSH_MSG_CHANNEL_EXTENDED_DATA) {
            this.buffer.putInt(1L);
        }
        this.buffer.putInt(0L);
        this.bufferLength = 0;
    }
}

