/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.cluster.requestor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.MessageAvailableConsumer;
import org.apache.activemq.MessageAvailableListener;
import org.apache.activemq.pool.PooledSession;
import org.apache.servicemix.jbi.cluster.requestor.AbstractPollingRequestorPool;
import org.apache.servicemix.jbi.cluster.requestor.Transacted;
import org.springframework.jms.JmsException;

public class ActiveMQJmsRequestorPool
extends AbstractPollingRequestorPool
implements ExceptionListener {
    protected final List<ActiveMQRequestor> polling = new LinkedList<ActiveMQRequestor>();
    protected final Queue<ActiveMQRequestor> requestors = new ConcurrentLinkedQueue<ActiveMQRequestor>();
    boolean consumersStarting;
    protected boolean cacheSessions = true;

    public boolean isCacheSessions() {
        return this.cacheSessions;
    }

    public void setCacheSessions(boolean cacheSessions) {
        this.cacheSessions = cacheSessions;
    }

    protected boolean sharedConnectionEnabled() {
        return true;
    }

    public void onException(JMSException exception) {
        this.handleListenerException(exception);
        if (this.sharedConnectionEnabled()) {
            try {
                this.refreshSharedConnection();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        this.recreateConsumers(true);
    }

    protected Connection createConnection() throws JMSException {
        Connection con = this.getConnectionFactory().createConnection();
        con.setExceptionListener((ExceptionListener)this);
        return con;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        super.setConnectionFactory(connectionFactory);
    }

    public void doInitialize() throws JMSException {
        this.startConsumers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startNewConsumer() throws JMSException {
        this.logger.debug((Object)"Creating a new consumer");
        ActiveMQRequestor requestor = (ActiveMQRequestor)this.createRequestor(true);
        this.polling.add(requestor);
        boolean success = false;
        try {
            requestor.getConsumer();
            success = true;
        }
        finally {
            if (!success) {
                this.polling.remove(requestor);
            }
        }
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        super.setConcurrentConsumers(concurrentConsumers);
        this.adjustConsumers();
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        super.setMaxConcurrentConsumers(maxConcurrentConsumers);
        this.adjustConsumers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void adjustConsumers() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            while (this.polling.size() > this.maxConcurrentConsumers) {
                ActiveMQRequestor requestor = this.polling.remove(0);
                try {
                    requestor.afterClose();
                }
                catch (Throwable t) {
                    requestor.destroy();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recreateConsumers(boolean destroyRequestors) {
        if (this.isRunning()) {
            ArrayList<ActiveMQRequestor> reqs;
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                reqs = new ArrayList<ActiveMQRequestor>(this.polling);
                this.polling.clear();
                if (destroyRequestors) {
                    reqs.addAll(this.requestors);
                    this.requestors.clear();
                }
            }
            for (ActiveMQRequestor requestor : reqs) {
                if (destroyRequestors) {
                    requestor.destroy();
                    continue;
                }
                requestor.destroyConsumer();
                try {
                    requestor.afterClose();
                }
                catch (Throwable t) {
                    requestor.destroy();
                }
            }
            this.startConsumers();
        }
    }

    protected void startConsumers() {
        Runnable r;
        if (!this.consumersStarting && this.rescheduleTaskIfNecessary(r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean alreadyRecovered = false;
                while (true) {
                    Object object = ActiveMQJmsRequestorPool.this.lifecycleMonitor;
                    synchronized (object) {
                        if (!ActiveMQJmsRequestorPool.this.isRunning() || ActiveMQJmsRequestorPool.this.polling.size() >= ActiveMQJmsRequestorPool.this.getConcurrentConsumers()) {
                            break;
                        }
                    }
                    try {
                        ActiveMQJmsRequestorPool.this.startNewConsumer();
                    }
                    catch (Throwable ex) {
                        ActiveMQJmsRequestorPool.this.handleListenerSetupFailure(ex, alreadyRecovered);
                        alreadyRecovered = true;
                        ActiveMQJmsRequestorPool.this.recoverAfterListenerSetupFailure();
                    }
                }
                ActiveMQJmsRequestorPool.this.consumersStarting = false;
            }
        })) {
            this.consumersStarting = true;
        }
    }

    protected AbstractPollingRequestorPool.Requestor createRequestor(boolean consume) throws JMSException {
        AbstractPollingRequestorPool.Requestor requestor = this.requestors.poll();
        if (requestor != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Choosing a requestor from pool");
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Creating a new requestor");
            }
            requestor = this.doCreateRequestor();
        }
        requestor.reset();
        return requestor;
    }

    protected AbstractPollingRequestorPool.Requestor doCreateRequestor() {
        return new ActiveMQRequestor();
    }

    public void setMessageSelector(String selector) {
        if (!this.sameSelector(selector, this.getMessageSelector())) {
            super.setMessageSelector(selector);
            this.recreateConsumers(false);
        }
    }

    protected boolean sameSelector(String s0, String s1) {
        return s0 == null && s1 == null || s0 != null && s0.equals(s1);
    }

    public class ActiveMQRequestor
    extends AbstractPollingRequestorPool.Requestor
    implements MessageAvailableListener,
    Runnable {
        public void begin() throws JmsException {
            boolean enlist = this.session != null;
            super.begin();
            if (enlist && ActiveMQJmsRequestorPool.this.transacted == Transacted.Xa) {
                try {
                    XAResource res;
                    if (this.session instanceof XASession) {
                        res = ((XASession)this.session).getXAResource();
                    } else if (this.session instanceof ActiveMQSession) {
                        res = ((ActiveMQSession)this.session).getTransactionContext();
                    } else if (this.session instanceof PooledSession) {
                        Method mth = this.session.getClass().getDeclaredMethod("getSession", new Class[0]);
                        mth.setAccessible(true);
                        ActiveMQSession s = (ActiveMQSession)mth.invoke((Object)this.session, new Object[0]);
                        res = s.getTransactionContext();
                    } else {
                        throw new IllegalStateException("Unable to retrieve XAResource from session " + this.session);
                    }
                    this.transaction.enlistResource(res);
                }
                catch (Exception e) {
                    throw new AbstractPollingRequestorPool.TransactionException(e);
                }
            }
        }

        public void close() {
            block18: {
                if (!this.suspended) {
                    try {
                        if (ActiveMQJmsRequestorPool.this.transacted == Transacted.Jms) {
                            if (this.rollbackOnly) {
                                this.session.rollback();
                            } else {
                                this.session.commit();
                            }
                            this.afterClose();
                            break block18;
                        }
                        if (ActiveMQJmsRequestorPool.this.transacted == Transacted.Xa) {
                            try {
                                if (this.rollbackOnly) {
                                    if (ActiveMQJmsRequestorPool.this.logger.isDebugEnabled()) {
                                        ActiveMQJmsRequestorPool.this.logger.debug((Object)"Rolling back XA transaction");
                                    }
                                    ActiveMQJmsRequestorPool.this.transactionManager.rollback();
                                } else {
                                    if (ActiveMQJmsRequestorPool.this.logger.isDebugEnabled()) {
                                        ActiveMQJmsRequestorPool.this.logger.debug((Object)"Committing XA transaction");
                                    }
                                    ActiveMQJmsRequestorPool.this.transactionManager.commit();
                                }
                            }
                            catch (Exception e) {
                                throw new AbstractPollingRequestorPool.TransactionException(e);
                            }
                            this.afterClose();
                            break block18;
                        }
                        if (ActiveMQJmsRequestorPool.this.transacted == Transacted.ClientAck) {
                            if (this.message != null) {
                                if (!this.rollbackOnly) {
                                    this.message.acknowledge();
                                } else {
                                    this.destroyConsumer();
                                }
                            }
                            this.afterClose();
                        } else {
                            this.afterClose();
                        }
                    }
                    catch (JMSException e) {
                        this.destroy();
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        protected synchronized MessageConsumer getConsumer() throws JMSException {
            if (this.consumer == null) {
                this.consumer = ActiveMQJmsRequestorPool.this.createConsumer(this.getSession());
                ((MessageAvailableConsumer)this.consumer).setAvailableListener((MessageAvailableListener)this);
            }
            return this.consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void afterClose() throws JMSException {
            if (ActiveMQJmsRequestorPool.this.isRunning() && this.consumer != null && ActiveMQJmsRequestorPool.this.sameSelector(ActiveMQJmsRequestorPool.this.getMessageSelector(), this.consumer.getMessageSelector())) {
                if (this.message != null) {
                    ActiveMQJmsRequestorPool.this.rescheduleTaskIfNecessary(this);
                    return;
                }
                Object object = ActiveMQJmsRequestorPool.this.lifecycleMonitor;
                synchronized (object) {
                    if (ActiveMQJmsRequestorPool.this.polling.size() < ActiveMQJmsRequestorPool.this.getMaxConcurrentConsumers()) {
                        ActiveMQJmsRequestorPool.this.polling.add(this);
                        return;
                    }
                }
            }
            if (ActiveMQJmsRequestorPool.this.cacheSessions && this.session != null) {
                this.destroyConsumer();
                ActiveMQJmsRequestorPool.this.requestors.add(this);
            } else {
                this.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessageAvailable(MessageConsumer consumer) {
            boolean isPolling;
            Object object = ActiveMQJmsRequestorPool.this.lifecycleMonitor;
            synchronized (object) {
                isPolling = ActiveMQJmsRequestorPool.this.polling.remove(this);
            }
            if (isPolling) {
                ActiveMQJmsRequestorPool.this.startConsumers();
                ActiveMQJmsRequestorPool.this.rescheduleTaskIfNecessary(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            boolean failure = true;
            try {
                this.reset();
                this.begin();
                this.message = this.getConsumer().receiveNoWait();
                if (this.message != null) {
                    ActiveMQJmsRequestorPool.this.listener.onMessage(this);
                }
                failure = false;
            }
            catch (Exception e) {
                ActiveMQJmsRequestorPool.this.logger.debug((Object)"Error processing message", (Throwable)e);
                this.setRollbackOnly();
            }
            finally {
                this.close();
                if (failure) {
                    ActiveMQJmsRequestorPool.this.recreateConsumers(true);
                }
            }
        }
    }
}

