/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.EndpointRegistry;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.core.CacheableReference;
import org.apache.servicemix.nmr.core.util.MapToDictionary;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterMatchingReference
implements CacheableReference,
Serializable {
    private final String filter;
    private volatile transient Filter osgiFilter;
    private volatile transient List<InternalEndpoint> matches;
    private transient EndpointRegistry registry;

    public FilterMatchingReference(String filter) throws InvalidSyntaxException {
        this.filter = filter;
        this.osgiFilter = FrameworkUtil.createFilter((String)filter);
    }

    public Iterable<InternalEndpoint> choose(EndpointRegistry registry) {
        List<InternalEndpoint> result = this.matches;
        if (result == null || this.registry != registry) {
            result = new ArrayList<InternalEndpoint>();
            for (Endpoint ep : registry.query(null)) {
                InternalEndpoint iep = (InternalEndpoint)ep;
                if (Boolean.valueOf((String)iep.getMetaData().get("UNTARGETABLE")).booleanValue() || !this.match(registry, iep)) continue;
                result.add(iep);
            }
            this.registry = registry;
            this.matches = result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean match(EndpointRegistry registry, InternalEndpoint endpoint) {
        Map epProps = registry.getProperties((Object)endpoint);
        if (this.osgiFilter == null) {
            FilterMatchingReference filterMatchingReference = this;
            synchronized (filterMatchingReference) {
                if (this.osgiFilter == null) {
                    try {
                        this.osgiFilter = FrameworkUtil.createFilter((String)this.filter);
                    }
                    catch (InvalidSyntaxException e) {
                        // empty catch block
                    }
                }
            }
        }
        return this.osgiFilter.match((Dictionary)new MapToDictionary(epProps));
    }

    public Document toXml() {
        return null;
    }

    @Override
    public void setDirty() {
        this.matches = null;
    }

    public String toString() {
        return "FilterMatchingReference[" + this.filter + "]";
    }
}

