/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.console.jline;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.AnsiWindowsTerminal;
import jline.ConsoleReader;
import jline.Terminal;
import jline.UnsupportedTerminal;
import org.apache.felix.karaf.shell.console.CloseShellException;
import org.apache.felix.karaf.shell.console.Completer;
import org.apache.felix.karaf.shell.console.completer.AggregateCompleter;
import org.apache.felix.karaf.shell.console.completer.SessionScopeCompleter;
import org.apache.felix.karaf.shell.console.jline.CompleterAsCompletor;
import org.osgi.service.command.CommandProcessor;
import org.osgi.service.command.CommandSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Console
implements Runnable {
    public static final String SHELL_INIT_SCRIPT = "karaf.shell.init.script";
    public static final String PROMPT = "PROMPT";
    public static final String DEFAULT_PROMPT = "\u001b[1m${USER}\u001b[0m@${APPLICATION}> ";
    public static final String PRINT_STACK_TRACES = "karaf.printStackTraces";
    private static final Logger LOGGER = LoggerFactory.getLogger(Console.class);
    private CommandSession session;
    private ConsoleReader reader;
    private BlockingQueue<Integer> queue;
    private boolean interrupt;
    private Thread pipe;
    private boolean running;
    private Runnable closeCallback;
    private Terminal terminal;
    private InputStream consoleInput;
    private InputStream in;
    private PrintStream out;
    private PrintStream err;
    private Callable<Boolean> printStackTraces;

    public Console(CommandProcessor processor, InputStream in, PrintStream out, PrintStream err, Terminal term, Completer completer, Runnable closeCallback, Callable<Boolean> printStackTraces) throws Exception {
        this.in = in;
        this.out = out;
        this.err = err;
        this.queue = new ArrayBlockingQueue<Integer>(1024);
        this.terminal = term == null ? new UnsupportedTerminal() : term;
        this.consoleInput = new ConsoleInputStream();
        this.session = processor.createSession(this.consoleInput, this.out, this.err);
        this.session.put("SCOPE", (Object)"shell:osgi:*");
        this.closeCallback = closeCallback;
        this.printStackTraces = printStackTraces;
        this.reader = new ConsoleReader(this.consoleInput, new PrintWriter(this.out), this.getClass().getResourceAsStream("keybinding.properties"), this.terminal);
        File file = new File(System.getProperty("user.home"), ".karaf/karaf.history");
        file.getParentFile().mkdirs();
        this.reader.getHistory().setHistoryFile(file);
        if (completer != null) {
            this.reader.addCompletor(new CompleterAsCompletor(new AggregateCompleter(Arrays.asList(completer, new SessionScopeCompleter(this.session, completer)))));
        }
        if (Boolean.getBoolean("jline.nobell")) {
            this.reader.setBellEnabled(false);
        }
        this.pipe = new Thread(new Pipe());
        this.pipe.setName("gogo shell pipe thread");
        this.pipe.setDaemon(true);
    }

    public CommandSession getSession() {
        return this.session;
    }

    public void close() {
        this.running = false;
        this.pipe.interrupt();
        Thread.interrupted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        this.pipe.start();
        this.welcome();
        String scriptFileName = System.getProperty(SHELL_INIT_SCRIPT);
        if (scriptFileName != null) {
            Reader r = null;
            try {
                int n;
                File scriptFile = new File(scriptFileName);
                r = new InputStreamReader(new FileInputStream(scriptFile));
                CharArrayWriter w = new CharArrayWriter();
                char[] buf = new char[8192];
                while ((n = r.read(buf)) > 0) {
                    w.write(buf, 0, n);
                }
                this.session.execute((CharSequence)new String(w.toCharArray()));
            }
            catch (Exception e) {
                LOGGER.debug("Error in initialization script", (Throwable)e);
                System.err.println("Error in initialization script: " + e.getMessage());
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        while (this.running) {
            try {
                String line = this.reader.readLine(this.getPrompt());
                if (line == null) break;
                Object result = this.session.execute((CharSequence)line);
                if (result == null) continue;
                this.session.getConsole().println(this.session.format(result, 0));
            }
            catch (InterruptedIOException e) {
            }
            catch (CloseShellException e) {
                break;
            }
            catch (Throwable t) {
                try {
                    if (this.printStackTraces.call().booleanValue()) {
                        t.printStackTrace(this.session.getConsole());
                        continue;
                    }
                    this.session.getConsole().println(t.getMessage());
                }
                catch (Exception exception) {}
            }
        }
        if (this.closeCallback != null) {
            this.closeCallback.run();
        }
    }

    protected void welcome() {
        Properties props = new Properties();
        this.loadProps(props, "org/apache/felix/karaf/shell/console/branding.properties");
        this.loadProps(props, "org/apache/felix/karaf/branding/branding.properties");
        String welcome = props.getProperty("welcome");
        if (welcome != null && welcome.length() > 0) {
            this.session.getConsole().println(welcome);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps(Properties props, String resource) {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(resource);
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected String getPrompt() {
        try {
            String prompt;
            try {
                Object p = this.session.get(PROMPT);
                prompt = p != null ? p.toString() : DEFAULT_PROMPT;
            }
            catch (Throwable t) {
                prompt = DEFAULT_PROMPT;
            }
            Matcher matcher = Pattern.compile("\\$\\{([^}]+)\\}").matcher(prompt);
            while (matcher.find()) {
                Object rep = this.session.get(matcher.group(1));
                if (rep == null) continue;
                prompt = prompt.replace(matcher.group(0), rep.toString());
                matcher.reset(prompt);
            }
            return prompt;
        }
        catch (Throwable t) {
            return "$ ";
        }
    }

    private void checkInterrupt() throws IOException {
        if (this.interrupt) {
            this.interrupt = false;
            throw new InterruptedIOException("Keyboard interruption");
        }
    }

    private void interrupt() {
        this.interrupt = true;
    }

    private class Pipe
    implements Runnable {
        private Pipe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                while (Console.this.running) {
                    int c;
                    block11: {
                        c = Console.this.terminal instanceof AnsiWindowsTerminal ? ((AnsiWindowsTerminal)Console.this.terminal).readDirectChar(Console.this.in) : Console.this.terminal.readCharacter(Console.this.in);
                        if (c != -1) break block11;
                        Console.this.queue.put(c);
                        return;
                    }
                    try {
                        if (c == 4) {
                            Console.this.err.println("^D");
                        } else if (c == 3) {
                            Console.this.err.println("^C");
                            Console.this.reader.getCursorBuffer().clearBuffer();
                            Console.this.interrupt();
                        }
                        Console.this.queue.put(c);
                    }
                    catch (Throwable t) {
                        Console.this.close();
                        return;
                    }
                }
            }
            finally {
                Console.this.close();
            }
        }
    }

    private class ConsoleInputStream
    extends InputStream {
        private ConsoleInputStream() {
        }

        private int read(boolean wait) throws IOException {
            Integer i;
            if (!Console.this.running) {
                return -1;
            }
            Console.this.checkInterrupt();
            if (wait) {
                try {
                    i = (Integer)Console.this.queue.take();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                Console.this.checkInterrupt();
            } else {
                i = (Integer)Console.this.queue.poll();
            }
            if (i == null) {
                return -1;
            }
            return i;
        }

        public int read() throws IOException {
            return this.read(true);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int nb;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int i = this.read(true);
            if (i < 0) {
                return -1;
            }
            b[off++] = (byte)i;
            for (nb = 1; nb < len; ++nb) {
                i = this.read(false);
                if (i < 0) {
                    return nb;
                }
                b[off++] = (byte)i;
            }
            return nb;
        }
    }
}

