/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.blueprint.reflect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geronimo.blueprint.mutable.MutableCollectionMetadata;
import org.apache.geronimo.blueprint.reflect.MetadataUtil;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionMetadataImpl
implements MutableCollectionMetadata {
    private Class collectionClass;
    private String valueType;
    private List<Metadata> values;

    public CollectionMetadataImpl() {
    }

    public CollectionMetadataImpl(Class collectionClass, String valueType, List<Metadata> values) {
        this.collectionClass = collectionClass;
        this.valueType = valueType;
        this.values = values;
    }

    public CollectionMetadataImpl(CollectionMetadata source) {
        this.collectionClass = source.getCollectionClass();
        this.valueType = source.getValueType();
        for (Metadata value : source.getValues()) {
            this.addValue(MetadataUtil.cloneMetadata(value));
        }
    }

    public Class getCollectionClass() {
        return this.collectionClass;
    }

    @Override
    public void setCollectionClass(Class collectionClass) {
        this.collectionClass = collectionClass;
    }

    @Override
    public String getValueType() {
        return this.valueType;
    }

    @Override
    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    @Override
    public List<Metadata> getValues() {
        if (this.values == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.values);
    }

    public void setValues(List<Metadata> values) {
        this.values = values != null ? new ArrayList<Metadata>(values) : null;
    }

    @Override
    public void addValue(Metadata value) {
        if (this.values == null) {
            this.values = new ArrayList<Metadata>();
        }
        this.values.add(value);
    }

    @Override
    public void removeValue(Metadata value) {
        if (this.values != null) {
            this.values.remove(value);
        }
    }

    public String toString() {
        return "CollectionMetadata[collectionClass=" + this.collectionClass + ", valueType='" + this.valueType + '\'' + ", values=" + this.values + ']';
    }
}

