/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.console.commands;

import java.io.PrintStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.gogo.commands.basic.ActionPreparator;
import org.apache.felix.gogo.commands.basic.DefaultActionPreparator;
import org.apache.felix.karaf.shell.console.BlueprintContainerAware;
import org.apache.felix.karaf.shell.console.BundleContextAware;
import org.apache.felix.karaf.shell.console.CompletableFunction;
import org.apache.felix.karaf.shell.console.Completer;
import org.apache.felix.karaf.shell.console.commands.GenericType;
import org.fusesource.jansi.Ansi;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.Converter;
import org.osgi.service.blueprint.container.ReifiedType;
import org.osgi.service.command.CommandSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintCommand
extends AbstractCommand
implements CompletableFunction {
    protected BlueprintContainer blueprintContainer;
    protected Converter blueprintConverter;
    protected String actionId;
    protected List<Completer> completers;

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public void setBlueprintConverter(Converter blueprintConverter) {
        this.blueprintConverter = blueprintConverter;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    @Override
    public List<Completer> getCompleters() {
        return this.completers;
    }

    public void setCompleters(List<Completer> completers) {
        this.completers = completers;
    }

    @Override
    protected ActionPreparator getPreparator() throws Exception {
        return new BlueprintActionPreparator();
    }

    @Override
    protected Action createNewAction() throws Exception {
        Action action = (Action)this.blueprintContainer.getComponentInstance(this.actionId);
        if (action instanceof BlueprintContainerAware) {
            ((BlueprintContainerAware)((Object)action)).setBlueprintContainer(this.blueprintContainer);
        }
        if (action instanceof BundleContextAware) {
            BundleContext context = (BundleContext)this.blueprintContainer.getComponentInstance("blueprintBundleContext");
            ((BundleContextAware)((Object)action)).setBundleContext(context);
        }
        return action;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BlueprintActionPreparator
    extends DefaultActionPreparator {
        BlueprintActionPreparator() {
        }

        @Override
        protected Object convert(Action action, CommandSession commandSession, Object o, Type type) throws Exception {
            return BlueprintCommand.this.blueprintConverter.convert(o, (ReifiedType)new GenericType(type));
        }

        @Override
        protected void printUsage(Command command, Set<Option> options, Set<Argument> args, PrintStream out) {
            ArrayList<Argument> arguments = new ArrayList<Argument>(args);
            Collections.sort(arguments, new Comparator<Argument>(){

                @Override
                public int compare(Argument o1, Argument o2) {
                    return Integer.valueOf(o1.index()).compareTo(o2.index());
                }
            });
            options = new HashSet<Option>(options);
            options.add(HELP);
            if (command != null && (command.description() != null || command.name() != null)) {
                out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("DESCRIPTION").a(Ansi.Attribute.RESET));
                out.print("\t");
                if (command.name() != null) {
                    out.println(Ansi.ansi().a(command.scope()).a(":").a(Ansi.Attribute.INTENSITY_BOLD).a(command.name()).a(Ansi.Attribute.RESET));
                    out.println();
                }
                out.print("\t");
                out.println(command.description());
                out.println();
            }
            StringBuffer syntax = new StringBuffer();
            if (command != null) {
                syntax.append(String.format("%s:%s", command.scope(), command.name()));
            }
            if (options.size() > 0) {
                syntax.append(" [options]");
            }
            if (arguments.size() > 0) {
                syntax.append(' ');
                for (Argument argument : arguments) {
                    if (!argument.required()) {
                        syntax.append(String.format("[%s] ", argument.name()));
                        continue;
                    }
                    syntax.append(String.format("%s ", argument.name()));
                }
            }
            out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("SYNTAX").a(Ansi.Attribute.RESET));
            out.print("\t");
            out.println(syntax.toString());
            out.println();
            if (arguments.size() > 0) {
                out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("ARGUMENTS").a(Ansi.Attribute.RESET));
                for (Argument argument : arguments) {
                    out.println(String.format("\t%-15s%s", argument.name(), argument.description()));
                }
                out.println();
            }
            if (options.size() > 0) {
                out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a("OPTIONS").a(Ansi.Attribute.RESET));
                for (Option option : options) {
                    String opt = option.name();
                    for (String alias : option.aliases()) {
                        opt = opt + ", " + alias;
                    }
                    out.print("\t");
                    out.println(opt);
                    out.println(String.format("\t%-15s%s", "", option.description()));
                }
                out.println();
            }
        }

        protected void printFormatted(String prefix, String str, int termWidth, PrintStream out) {
            int pfxLen = this.length(prefix);
        }

        protected int length(String str) {
            return str.length();
        }
    }
}

