/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.blueprint.ext;

import org.apache.geronimo.blueprint.ComponentDefinitionRegistry;
import org.apache.geronimo.blueprint.ExtendedBeanMetadata;
import org.apache.geronimo.blueprint.ext.AbstractPropertyPlaceholder;
import org.apache.geronimo.blueprint.mutable.MutableBeanMetadata;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.ValueMetadata;

public class PlaceholdersUtils {
    public static void validatePlaceholder(MutableBeanMetadata metadata, ComponentDefinitionRegistry registry) {
        String prefix = PlaceholdersUtils.getPlaceholderProperty(metadata, "placeholderPrefix");
        String suffix = PlaceholdersUtils.getPlaceholderProperty(metadata, "placeholderSuffix");
        for (String id : registry.getComponentDefinitionNames()) {
            ExtendedBeanMetadata bean;
            ComponentMetadata component = registry.getComponentDefinition(id);
            if (!(component instanceof ExtendedBeanMetadata) || (bean = (ExtendedBeanMetadata)component).getRuntimeClass() == null || !AbstractPropertyPlaceholder.class.isAssignableFrom(bean.getRuntimeClass())) continue;
            String otherPrefix = PlaceholdersUtils.getPlaceholderProperty(bean, "placeholderPrefix");
            String otherSuffix = PlaceholdersUtils.getPlaceholderProperty(bean, "placeholderSuffix");
            if (!prefix.equals(otherPrefix) || !suffix.equals(otherSuffix)) continue;
            throw new ComponentDefinitionException("Multiple placeholders with the same prefix and suffix are not allowed");
        }
    }

    private static String getPlaceholderProperty(BeanMetadata bean, String name) {
        for (BeanProperty property : bean.getProperties()) {
            if (!name.equals(property.getName())) continue;
            ValueMetadata value = (ValueMetadata)property.getValue();
            return value.getStringValue();
        }
        return null;
    }
}

