/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.audit.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.servicemix.nmr.audit.AuditorMBean;
import org.apache.servicemix.nmr.audit.AuditorQueryMBean;
import org.apache.servicemix.nmr.audit.commands.AuditCommandSupport;

@Command(scope="audit", name="find", description="Find exchange ids.")
public class FindCommand
extends AuditCommandSupport {
    @Argument(required=true)
    String query;

    protected Object doExecute(AuditorMBean auditor) throws Exception {
        if (!(auditor instanceof AuditorQueryMBean)) {
            System.err.println("Auditor does not support search.  The auditor should be wrapped within a lucene auditor");
            return null;
        }
        return this.doExecute((AuditorQueryMBean)auditor);
    }

    protected Object doExecute(AuditorQueryMBean auditor) throws Exception {
        String[] ids = auditor.findExchangesIdsByQuery(this.query);
        if (ids == null || ids.length == 0) {
            System.out.println("No matching exchanges");
        } else {
            for (String id : ids) {
                if (id == null) continue;
                System.out.println(id);
            }
        }
        return null;
    }
}

