/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.features.command;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.karaf.features.Feature;
import org.apache.felix.karaf.features.FeaturesService;
import org.apache.felix.karaf.features.Repository;
import org.apache.felix.karaf.features.command.FeaturesCommandSupport;

@Command(scope="features", name="list", description="Lists all existing features available from the defined repositories.")
public class ListFeaturesCommand
extends FeaturesCommandSupport {
    @Option(name="-i", aliases={"--installed"}, description="Display a list of all installed features only", required=false, multiValued=false)
    boolean installed;
    private static final String STATE = "State";
    private static final String INSTALLED = "installed  ";
    private static final String UNINSTALLED = "uninstalled";
    private static final String VERSION = "Version";
    private static final String NAME = "Name";
    private static final String REPOSITORY = "Repository";

    protected void doExecute(FeaturesService admin) throws Exception {
        int i;
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (Repository r : Arrays.asList(admin.listRepositories())) {
            for (Feature f : r.getFeatures()) {
                if (this.installed && !admin.isInstalled(f)) continue;
                features.add(f);
                repositories.add(r);
            }
        }
        if (features.size() == 0) {
            if (this.installed) {
                System.out.println("No features installed.");
            } else {
                System.out.println("No features available.");
            }
            return;
        }
        int maxVersionSize = VERSION.length();
        for (Feature f : features) {
            maxVersionSize = Math.max(maxVersionSize, f.getVersion().length());
        }
        int maxNameSize = NAME.length();
        for (Feature f : features) {
            maxNameSize = Math.max(maxNameSize, f.getName().length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(STATE).append("         ").append(VERSION).append("   ");
        for (i = VERSION.length(); i < maxVersionSize; ++i) {
            sb.append(" ");
        }
        sb.append(NAME).append(" ");
        for (i = NAME.length(); i < maxNameSize; ++i) {
            sb.append(" ");
        }
        sb.append(REPOSITORY);
        System.out.println(sb.toString());
        boolean needsLegend = false;
        for (Feature f : features) {
            int i2;
            sb.setLength(0);
            sb.append("[");
            if (admin.isInstalled(f)) {
                sb.append(INSTALLED);
            } else {
                sb.append(UNINSTALLED);
            }
            sb.append("] [");
            String str = f.getVersion();
            sb.append(str);
            for (i2 = str.length(); i2 < maxVersionSize; ++i2) {
                sb.append(" ");
            }
            sb.append("] ");
            str = f.getName();
            sb.append(str);
            for (i2 = str.length(); i2 < maxNameSize; ++i2) {
                sb.append(" ");
            }
            sb.append(" ");
            String name = ((Repository)repositories.get(0)).getName();
            sb.append(name);
            repositories.remove(0);
            System.out.println(sb.toString());
            if (name.charAt(name.length() - 1) != '*') continue;
            needsLegend = true;
        }
        if (needsLegend) {
            System.out.println("* Installed via deploy directory");
        }
    }
}

