/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.main;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.felix.karaf.main.BootstrapLogManager;
import org.apache.felix.karaf.main.Lock;
import org.apache.felix.karaf.main.Statements;

public class OracleJDBCLock
implements Lock {
    private static final Logger LOG = Logger.getLogger(OracleJDBCLock.class.getName());
    private static final String PROPERTY_LOCK_URL = "karaf.lock.jdbc.url";
    private static final String PROPERTY_LOCK_JDBC_DRIVER = "karaf.lock.jdbc.driver";
    private static final String PROPERTY_LOCK_JDBC_USER = "karaf.lock.jdbc.user";
    private static final String PROPERTY_LOCK_JDBC_PASSWORD = "karaf.lock.jdbc.password";
    private static final String PROPERTY_LOCK_JDBC_TABLE = "karaf.lock.jdbc.table";
    private static final String PROPERTY_LOCK_JDBC_CLUSTERNAME = "karaf.lock.jdbc.clustername";
    private static final String PROPERTY_LOCK_JDBC_TIMEOUT = "karaf.lock.jdbc.timeout";
    private final Statements statements;
    private Connection lockConnection;
    private String url;
    private String database;
    private String driver;
    private String user;
    private String password;
    private String table;
    private String clusterName;
    private int timeout;

    public OracleJDBCLock(Properties props) {
        LOG.addHandler(BootstrapLogManager.getDefaultHandler());
        this.url = props.getProperty(PROPERTY_LOCK_URL);
        this.driver = props.getProperty(PROPERTY_LOCK_JDBC_DRIVER);
        this.user = props.getProperty(PROPERTY_LOCK_JDBC_USER);
        this.password = props.getProperty(PROPERTY_LOCK_JDBC_PASSWORD);
        this.table = props.getProperty(PROPERTY_LOCK_JDBC_TABLE);
        this.clusterName = props.getProperty(PROPERTY_LOCK_JDBC_CLUSTERNAME);
        String time = props.getProperty(PROPERTY_LOCK_JDBC_TIMEOUT);
        this.lockConnection = null;
        if (this.table == null) {
            this.table = "KARAF_LOCK";
        }
        if (this.clusterName == null) {
            this.clusterName = "karaf";
        }
        this.timeout = time != null ? Integer.parseInt(time) * 1000 : 10000;
        if (this.user == null) {
            this.user = "";
        }
        if (this.password == null) {
            this.password = "";
        }
        int db = props.getProperty(PROPERTY_LOCK_URL).lastIndexOf(":");
        this.url = props.getProperty(PROPERTY_LOCK_URL);
        this.database = props.getProperty(PROPERTY_LOCK_URL).substring(db + 1);
        this.statements = new Statements(this.database, this.table, this.clusterName);
        this.statements.setDBCreateStatement("create database " + this.database);
        this.statements.setCreateStatement("create table " + this.table + " (MOMENT number(20), NODE varchar2(20))");
        this.statements.setPopulateStatement("insert into " + this.table + " (MOMENT, NODE) values ('1', '" + this.clusterName + "')");
        this.statements.setColumnNames("MOMENT", "NODE");
        this.testDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDB() {
        try {
            this.lockConnection = this.getConnection(this.driver, this.url, this.user, this.password);
            this.lockConnection.setAutoCommit(false);
            this.statements.init(this.lockConnection);
        }
        catch (Exception e) {
            LOG.severe("Error occured while attempting to obtain connection: " + e + " " + e.getMessage());
        }
        finally {
            try {
                this.lockConnection.close();
                this.lockConnection = null;
            }
            catch (Exception f) {
                LOG.severe("Error occured while cleaning up connection: " + f + " " + f.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setUpdateCursor() throws Exception {
        Statement statement = null;
        boolean result = false;
        try {
            if (this.lockConnection != null && !this.lockConnection.isClosed()) {
                LOG.fine("OracleJDBCLock#setUpdateCursor:: connection already established.");
                boolean bl = true;
                return bl;
            }
            LOG.fine("OracleJDBCLock#setUpdateCursor:: connection: " + this.url);
            this.lockConnection = this.getConnection(this.driver, this.url, this.user, this.password);
            this.lockConnection.setAutoCommit(false);
            this.statements.init(this.lockConnection);
            String sql = "SELECT * FROM " + this.table + " FOR UPDATE NOWAIT";
            statement = this.lockConnection.prepareStatement(sql);
            result = statement.execute();
        }
        catch (Exception e) {
            LOG.warning("Could not obtain connection: " + e.getMessage());
            this.lockConnection.close();
            this.lockConnection = null;
        }
        finally {
            if (null != statement) {
                try {
                    LOG.fine("Cleaning up DB connection.");
                    statement.close();
                }
                catch (SQLException e1) {
                    LOG.severe("Caught while closing statement: " + e1.getMessage());
                }
                statement = null;
            }
        }
        LOG.fine("Connected to data source: " + this.url + " With RS: " + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock() {
        Statement statement = null;
        boolean result = false;
        try {
            if (!this.setUpdateCursor()) {
                LOG.severe("Could not set DB update cursor");
                boolean bl = result;
                return bl;
            }
            LOG.fine("OracleJDBCLock#lock:: have set Update Cursor, now perform query");
            String up = "SELECT * FROM " + this.table;
            statement = this.lockConnection.prepareStatement(up);
            boolean bl = statement.execute();
            return bl;
        }
        catch (Exception e) {
            LOG.warning("Failed to acquire database lock: " + e.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.severe("Failed to close statement" + e);
                }
            }
        }
        return result;
    }

    public void release() throws Exception {
        if (this.lockConnection != null && !this.lockConnection.isClosed()) {
            this.lockConnection.rollback();
            this.lockConnection.close();
            this.lockConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() throws Exception {
        if (this.lockConnection == null || this.lockConnection.isClosed()) {
            LOG.warning("Lost lock!");
            return false;
        }
        Statement statement = null;
        try {
            String up = "SELECT * FROM " + this.table;
            statement = this.lockConnection.prepareStatement(up);
            boolean bl = statement.execute();
            return bl;
        }
        catch (Exception e) {
            LOG.warning("Failed to access database. " + e.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.severe("Failed to close statement" + e);
                }
            }
        }
        return false;
    }

    private Connection getConnection(String driver, String url, String username, String password) throws Exception {
        Connection conn = null;
        try {
            Class.forName(driver);
            conn = DriverManager.getConnection(url, username, password);
        }
        catch (Exception e) {
            LOG.severe("Error occured while setting up JDBC connection: " + e);
            throw e;
        }
        return conn;
    }
}

