/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.InstallationContext;
import javax.jbi.management.MBeanNames;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.deployer.descriptor.ComponentDesc;
import org.apache.servicemix.jbi.deployer.descriptor.InstallationDescriptorExtension;
import org.apache.servicemix.jbi.deployer.descriptor.SharedLibraryList;
import org.apache.servicemix.jbi.runtime.Environment;
import org.apache.servicemix.nmr.management.Nameable;
import org.fusesource.commons.management.ManagementStrategy;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class InstallationContextImpl
implements InstallationContext,
ComponentContext,
MBeanNames {
    private ComponentDesc descriptor;
    private ManagementStrategy managementStrategy;
    private MBeanServer mbeanServer;
    private Environment environment;
    private File installRoot;
    private List<String> classPathElements = Collections.emptyList();
    private boolean install = true;

    public InstallationContextImpl(ComponentDesc descriptor, Environment environment, ManagementStrategy managementStrategy, MBeanServer mbeanServer) {
        this.descriptor = descriptor;
        this.environment = environment;
        this.managementStrategy = managementStrategy;
        this.mbeanServer = mbeanServer;
        if (descriptor.getComponentClassPath() != null && descriptor.getComponentClassPath().getPathElements() != null && descriptor.getComponentClassPath().getPathElements().length > 0) {
            String[] elems = descriptor.getComponentClassPath().getPathElements();
            for (int i = 0; i < elems.length; ++i) {
                elems[i] = File.separatorChar == '\\' ? elems[i].replace('/', '\\') : elems[i].replace('\\', '/');
            }
            this.setClassPathElements(Arrays.asList(elems));
        }
    }

    public ComponentDesc getDescriptor() {
        return this.descriptor;
    }

    public String[] getSharedLibraries() {
        return InstallationContextImpl.getSharedLibraries(this.descriptor.getSharedLibraries());
    }

    public String getComponentClassName() {
        return this.descriptor.getComponentClassName();
    }

    public List getClassPathElements() {
        return this.classPathElements;
    }

    public String getComponentName() {
        return this.descriptor.getIdentification().getName();
    }

    public ComponentContext getContext() {
        return this;
    }

    public String getInstallRoot() {
        return this.installRoot != null ? this.installRoot.getAbsolutePath() : ".";
    }

    public DocumentFragment getInstallationDescriptorExtension() {
        InstallationDescriptorExtension desc = this.descriptor.getDescriptorExtension();
        return desc != null ? desc.getDescriptorExtension() : null;
    }

    public boolean isInstall() {
        return this.install;
    }

    public final void setClassPathElements(List classPathElements) {
        if (classPathElements == null) {
            throw new IllegalArgumentException("classPathElements is null");
        }
        if (classPathElements.isEmpty()) {
            throw new IllegalArgumentException("classPathElements is empty");
        }
        for (Object obj : classPathElements) {
            if (!(obj instanceof String)) {
                throw new IllegalArgumentException("classPathElements must contain element of type String");
            }
            String element = (String)obj;
            String sep = "\\".equals(File.separator) ? "/" : "\\";
            int offset = element.indexOf(sep);
            if (offset > -1) {
                throw new IllegalArgumentException("classPathElements contains an invalid file separator '" + sep + "'");
            }
            File f = new File(element);
            if (!f.isAbsolute()) continue;
            throw new IllegalArgumentException("classPathElements should not contain absolute paths");
        }
        this.classPathElements = new ArrayList<String>(classPathElements);
    }

    public ServiceEndpoint activateEndpoint(QName serviceName, String endpointName) throws JBIException {
        throw new IllegalStateException("This operation is not available at installation time");
    }

    public void deactivateEndpoint(ServiceEndpoint endpoint) throws JBIException {
        throw new IllegalStateException("This operation is not available at installation time");
    }

    public void registerExternalEndpoint(ServiceEndpoint externalEndpoint) throws JBIException {
        throw new IllegalStateException("This operation is not available at installation time");
    }

    public void deregisterExternalEndpoint(ServiceEndpoint externalEndpoint) throws JBIException {
        throw new IllegalStateException("This operation is not available at installation time");
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        throw new IllegalStateException("This operation is not available at installation time");
    }

    public DeliveryChannel getDeliveryChannel() throws MessagingException {
        throw new IllegalStateException("This operation is not available at installation time");
    }

    public ServiceEndpoint getEndpoint(QName service, String name) {
        throw new IllegalStateException("This operation is not available at installation time");
    }

    public Document getEndpointDescriptor(ServiceEndpoint endpoint) throws JBIException {
        throw new IllegalStateException("This operation is not available at installation time");
    }

    public ServiceEndpoint[] getEndpoints(QName interfaceName) {
        throw new IllegalStateException("This operation is not available at installation time");
    }

    public ServiceEndpoint[] getEndpointsForService(QName serviceName) {
        throw new IllegalStateException("This operation is not available at installation time");
    }

    public ServiceEndpoint[] getExternalEndpoints(QName interfaceName) {
        throw new IllegalStateException("This operation is not available at installation time");
    }

    public ServiceEndpoint[] getExternalEndpointsForService(QName serviceName) {
        throw new IllegalStateException("This operation is not available at installation time");
    }

    public Logger getLogger(String suffix, String resourceBundleName) throws MissingResourceException, JBIException {
        throw new IllegalStateException("This operation is not available at installation time");
    }

    public MBeanNames getMBeanNames() {
        return this;
    }

    public String getWorkspaceRoot() {
        throw new IllegalStateException("This operation is not available at installation time");
    }

    public ObjectName createCustomComponentMBeanName(String customName) {
        ObjectName name = null;
        if (this.managementStrategy != null) {
            Nameable nameable = new Nameable(){

                public String getName() {
                    return InstallationContextImpl.this.descriptor.getIdentification().getName();
                }

                public String getParent() {
                    return null;
                }

                public String getMainType() {
                    return null;
                }

                public String getSubType() {
                    return null;
                }

                public String getVersion() {
                    return null;
                }

                public Class getPrimaryInterface() {
                    return null;
                }
            };
            try {
                name = (ObjectName)this.managementStrategy.getManagedObjectName((Object)nameable, customName, ObjectName.class);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return name;
    }

    public String getJmxDomainName() {
        String name = null;
        if (this.managementStrategy != null) {
            try {
                name = (String)this.managementStrategy.getManagedObjectName(null, null, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return name;
    }

    public void setInstall(boolean install) {
        this.install = install;
    }

    public void setInstallRoot(File installRoot) {
        this.installRoot = installRoot;
    }

    public boolean isBinding() {
        return this.descriptor.isBindingComponent();
    }

    public boolean isEngine() {
        return this.descriptor.isServiceEngine();
    }

    public String getComponentDescription() {
        return this.descriptor.getIdentification().getDescription();
    }

    private static String[] getSharedLibraries(SharedLibraryList[] sharedLibraries) {
        if (sharedLibraries == null || sharedLibraries.length == 0) {
            return null;
        }
        String[] names = new String[sharedLibraries.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = sharedLibraries[i].getName();
        }
        return names;
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public InitialContext getNamingContext() {
        return this.environment.getNamingContext();
    }

    public Object getTransactionManager() {
        return this.environment.getTransactionManager();
    }
}

