/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.naming;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.spi.NamingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialContextWrapper
implements DirContext {
    public static final String OSGI_SCHEME = "osgi";
    private final Context osgiContext;
    private Hashtable<Object, Object> env = new Hashtable();
    private Context delegate;

    public InitialContextWrapper(Context delegate, Context osgiContext, Hashtable<?, ?> environment) throws NamingException {
        this.delegate = delegate;
        this.osgiContext = osgiContext;
    }

    protected Context getURLOrDefaultInitCtx(String name) throws NamingException {
        Context ctx;
        String scheme = InitialContextWrapper.getURLScheme(name);
        if (OSGI_SCHEME.equals(scheme)) {
            return this.osgiContext;
        }
        if (scheme != null && (ctx = NamingManager.getURLContext(scheme, this.delegate.getEnvironment())) != null) {
            return ctx;
        }
        return this.delegate;
    }

    private static String getURLScheme(String str) {
        int colon_posn = str.indexOf(58);
        int slash_posn = str.indexOf(47);
        if (colon_posn > 0 && (slash_posn == -1 || colon_posn < slash_posn)) {
            return str.substring(0, colon_posn);
        }
        return null;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        Context ctx = this.getDelegate();
        if (ctx != null) {
            ctx.addToEnvironment(propName, propVal);
        }
        return this.env.put(propName, propVal);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.findContext(name).bind(name, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.findContext(name).bind(name, obj);
    }

    @Override
    public void close() throws NamingException {
        if (this.delegate != null) {
            this.delegate.close();
        }
        this.env.clear();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.findContext(name).composeName(name, prefix);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.findContext(name).composeName(name, prefix);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.findContext(name).createSubcontext(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.findContext(name).createSubcontext(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.findContext(name).destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.findContext(name).destroySubcontext(name);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        Hashtable<Object, Object> theEnv = new Hashtable<Object, Object>();
        theEnv.putAll(this.env);
        return theEnv;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.getDelegate().getNameInNamespace();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.findContext(name).getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.findContext(name).getNameParser(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.findContext(name).list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.findContext(name).list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.findContext(name).listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.findContext(name).listBindings(name);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.findContext(name).lookup(name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.findContext(name).lookup(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.findContext(name).lookupLink(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.findContext(name).lookupLink(name);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.findContext(name).rebind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.findContext(name).rebind(name, obj);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        Context ctx = this.getDelegate();
        if (ctx != null) {
            ctx.removeFromEnvironment(propName);
        }
        return this.env.remove(propName);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.findContext(oldName).rename(oldName, newName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.findContext(oldName).rename(oldName, newName);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.findContext(name).unbind(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.findContext(name).unbind(name);
    }

    protected Context findContext(Name name) throws NamingException {
        return this.findContext(name.toString());
    }

    protected Context findContext(String name) throws NamingException {
        String packages;
        Context toReturn = null;
        toReturn = name.contains(":") ? this.getURLOrDefaultInitCtx(name) : this.getDelegate();
        if (toReturn != null && (packages = System.getProperty("java.naming.factory.url.pkgs", null)) != null) {
            toReturn.addToEnvironment("java.naming.factory.url.pkgs", packages);
        }
        return toReturn;
    }

    private Context getDelegate() throws NamingException {
        return this.delegate;
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return ((DirContext)this.findContext(name)).getAttributes(name);
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return ((DirContext)this.findContext(name)).getAttributes(name);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return ((DirContext)this.findContext(name)).getAttributes(name, attrIds);
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return ((DirContext)this.findContext(name)).getAttributes(name, attrIds);
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        ((DirContext)this.findContext(name)).modifyAttributes(name, mod_op, attrs);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        ((DirContext)this.findContext(name)).modifyAttributes(name, mod_op, attrs);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        ((DirContext)this.findContext(name)).modifyAttributes(name, mods);
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        ((DirContext)this.findContext(name)).modifyAttributes(name, mods);
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        ((DirContext)this.findContext(name)).bind(name, obj, attrs);
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        ((DirContext)this.findContext(name)).bind(name, obj, attrs);
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        ((DirContext)this.findContext(name)).rebind(name, obj, attrs);
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        ((DirContext)this.findContext(name)).rebind(name, obj, attrs);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return ((DirContext)this.findContext(name)).createSubcontext(name, attrs);
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return ((DirContext)this.findContext(name)).createSubcontext(name, attrs);
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        return ((DirContext)this.findContext(name)).getSchema(name);
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        return ((DirContext)this.findContext(name)).getSchema(name);
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return ((DirContext)this.findContext(name)).getSchemaClassDefinition(name);
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        return ((DirContext)this.findContext(name)).getSchemaClassDefinition(name);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, matchingAttributes);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, matchingAttributes);
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, filter, cons);
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, filter, cons);
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, filterExpr, filterArgs, cons);
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, filterExpr, filterArgs, cons);
    }
}

