/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.runtime.impl;

import java.util.Map;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.runtime.impl.utils.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceEndpointImpl
implements ServiceEndpoint {
    public static final String JBI_NAMESPACE = "http://java.sun.com/jbi/end-point-reference";
    public static final String JBI_PREFIX = "jbi:";
    public static final String JBI_ENDPOINT_REFERENCE = "end-point-reference";
    public static final String JBI_SERVICE_NAME = "service-name";
    public static final String JBI_ENDPOINT_NAME = "end-point-name";
    public static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    private static final Log LOG = LogFactory.getLog(ServiceEndpointImpl.class);
    private final Map<String, ?> properties;
    private final QName serviceName;
    private final String endpointName;
    private final QName[] interfaces;

    public ServiceEndpointImpl(Map<String, ?> properties) {
        this.properties = properties;
        this.serviceName = ServiceEndpointImpl.getQName(properties.get("SERVICE_NAME"));
        this.endpointName = (String)properties.get("ENDPOINT_NAME");
        this.interfaces = ServiceEndpointImpl.getQNames(properties.get("INTERFACE_NAME"));
    }

    public ServiceEndpointImpl(QName serviceName, String endpointName) {
        this.serviceName = serviceName;
        this.endpointName = endpointName;
        this.interfaces = null;
        this.properties = null;
    }

    public DocumentFragment getAsReference(QName operationName) {
        try {
            Document doc = DOMUtil.newDocument();
            DocumentFragment fragment = doc.createDocumentFragment();
            Element epr = doc.createElementNS(JBI_NAMESPACE, "jbi:end-point-reference");
            epr.setAttributeNS(XMLNS_NAMESPACE, "xmlns:sns", this.getServiceName().getNamespaceURI());
            epr.setAttributeNS(JBI_NAMESPACE, "jbi:service-name", "sns:" + this.getServiceName().getLocalPart());
            epr.setAttributeNS(JBI_NAMESPACE, "jbi:end-point-name", this.getEndpointName());
            fragment.appendChild(epr);
            return fragment;
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to create reference for ServiceEndpoint " + this), (Throwable)e);
            return null;
        }
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public QName[] getInterfaces() {
        return this.interfaces;
    }

    public Map<String, ?> getProperties() {
        return this.properties;
    }

    private static QName getQName(Object o) {
        if (o instanceof QName) {
            return (QName)o;
        }
        if (o instanceof String) {
            return QName.valueOf((String)o);
        }
        return null;
    }

    private static QName[] getQNames(Object o) {
        if (o instanceof QName[]) {
            return (QName[])o;
        }
        if (o instanceof QName) {
            return new QName[]{(QName)o};
        }
        if (o instanceof String) {
            String[] s = ((String)o).split(",");
            QName[] q = new QName[s.length];
            for (int i = 0; i < s.length; ++i) {
                q[i] = QName.valueOf(s[i]);
            }
            return q;
        }
        return null;
    }
}

