/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.audit.lucene;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.servicemix.nmr.audit.lucene.LuceneCallback;

public class DefaultLuceneCallback
implements LuceneCallback {
    public static final int SEARCH_SIZE = 100;
    private String field;
    private String query;

    public DefaultLuceneCallback(String field, String query) {
        this.field = field;
        this.query = query;
    }

    public Object doCallback(IndexSearcher is) throws IOException {
        try {
            QueryParser qp = new QueryParser(this.field, (Analyzer)new StandardAnalyzer());
            Query queryObj = qp.parse(this.query);
            TopDocs topdocs = is.search(queryObj, 100);
            int total = topdocs.totalHits;
            String[] ids = new String[total];
            for (int i = 0; i < total; ++i) {
                ScoreDoc d = topdocs.scoreDocs[i];
                ids[i] = is.doc(d.doc).get("id");
            }
            return ids;
        }
        catch (ParseException pe) {
            throw (IOException)new IOException("Error parsing query").initCause(pe);
        }
    }
}

