/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.osgi.Util;
import org.osgi.framework.Bundle;

@Command(scope="osgi", name="headers", description="Displays OSGi headers of a given bundle")
public class Headers
extends OsgiCommandSupport {
    @Argument(index=0, name="ids", description="A list of bundle IDs separated by whitespaces", required=false, multiValued=true)
    List<Long> ids;

    protected Object doExecute() throws Exception {
        if (this.ids != null && !this.ids.isEmpty()) {
            for (long id : this.ids) {
                Bundle bundle = this.getBundleContext().getBundle(id);
                if (bundle != null) {
                    this.printHeaders(bundle);
                    continue;
                }
                System.err.println("Bundle ID " + id + " is invalid.");
            }
        } else {
            Bundle[] bundles = this.getBundleContext().getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                this.printHeaders(bundles[i]);
            }
        }
        return null;
    }

    protected void printHeaders(Bundle bundle) throws Exception {
        String title = Util.getBundleName(bundle);
        System.out.println("\n" + title);
        System.out.println(Util.getUnderlineString(title));
        Dictionary dict = bundle.getHeaders();
        Enumeration keys = dict.keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            Object v = dict.get(k);
            System.out.println(k + " = " + Util.getValueString(v));
        }
    }
}

