/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.webconsole.gogo;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.AggregateCompleter;
import org.apache.karaf.shell.console.jline.Console;
import org.apache.karaf.webconsole.gogo.Terminal;
import org.apache.karaf.webconsole.gogo.WebTerminal;
import org.osgi.framework.BundleContext;
import org.osgi.service.command.CommandProcessor;
import org.osgi.service.command.CommandSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GogoPlugin
extends AbstractWebConsolePlugin {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "gogo";
    public static final String LABEL = "Gogo";
    public static final int TERM_WIDTH = 120;
    public static final int TERM_HEIGHT = 39;
    private Log log = LogFactory.getLog(GogoPlugin.class);
    private BundleContext bundleContext;
    private CommandProcessor commandProcessor;
    private List<Completer> completers;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setCommandProcessor(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public void setCompleters(List<Completer> completers) {
        this.completers = completers;
    }

    public void start() {
        super.activate(this.bundleContext);
        this.log.info((Object)"Gogo plugin activated");
    }

    public void stop() {
        this.log.info((Object)"Gogo plugin deactivated");
        super.deactivate();
    }

    public String getLabel() {
        return NAME;
    }

    public String getTitle() {
        return LABEL;
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        String appRoot = request.getContextPath() + request.getServletPath();
        pw.println("<link href=\"" + appRoot + "/gogo/res/ui/gogo.css\" rel=\"stylesheet\" type=\"text/css\" />");
        pw.println("<script src=\"" + appRoot + "/gogo/res/ui/gogo.js\" type=\"text/javascript\"></script>");
        pw.println("<div id='console'><div id='term'></div></div>");
        pw.println("<script type=\"text/javascript\"><!--");
        pw.println("window.onload = function() { gogo.Terminal(document.getElementById(\"term\"), 120, 39); }");
        pw.println("--></script>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getResource(String path) {
        path = path.substring(NAME.length() + 1);
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(path);
        if (url != null) {
            InputStream ins = null;
            try {
                ins = url.openStream();
                if (ins == null) {
                    this.log.error((Object)("failed to open " + url));
                    url = null;
                }
            }
            catch (IOException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                url = null;
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (IOException e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return url;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String f;
        String str;
        String dump;
        String encoding = request.getHeader("Accept-Encoding");
        boolean supportsGzip = encoding != null && encoding.toLowerCase().indexOf("gzip") > -1;
        SessionTerminal st = (SessionTerminal)request.getSession(true).getAttribute("terminal");
        if (st == null || st.isClosed()) {
            st = new SessionTerminal();
            request.getSession().setAttribute("terminal", (Object)st);
        }
        if ((dump = st.handle(str = request.getParameter("k"), (f = request.getParameter("f")) != null && f.length() > 0)) != null) {
            if (supportsGzip) {
                response.setHeader("Content-Encoding", "gzip");
                response.setHeader("Content-Type", "text/html");
                try {
                    GZIPOutputStream gzos = new GZIPOutputStream((OutputStream)response.getOutputStream());
                    gzos.write(dump.getBytes());
                    gzos.close();
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                }
            } else {
                response.getOutputStream().write(dump.getBytes());
            }
        }
    }

    public class SessionTerminal
    implements Runnable {
        private Terminal terminal;
        private Console console;
        private PipedOutputStream in;
        private PipedInputStream out;
        private boolean closed;

        public SessionTerminal() throws IOException {
            try {
                this.terminal = new Terminal(120, 39);
                this.terminal.write("\u001b[20h");
                this.in = new PipedOutputStream();
                this.out = new PipedInputStream();
                PrintStream pipedOut = new PrintStream(new PipedOutputStream(this.out), true);
                this.console = new Console(GogoPlugin.this.commandProcessor, (InputStream)new PipedInputStream(this.in), pipedOut, pipedOut, (jline.Terminal)new WebTerminal(120, 39), (Completer)new AggregateCompleter((Collection)GogoPlugin.this.completers), null);
                CommandSession session = this.console.getSession();
                session.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
                session.put("USER", (Object)"karaf");
                session.put("COLUMNS", (Object)Integer.toString(120));
                session.put("LINES", (Object)Integer.toString(39));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw (IOException)new IOException().initCause(e);
            }
            new Thread((Runnable)this.console).start();
            new Thread(this).start();
        }

        public boolean isClosed() {
            return this.closed;
        }

        public String handle(String str, boolean forceDump) throws IOException {
            try {
                if (str != null && str.length() > 0) {
                    String d = this.terminal.pipe(str);
                    for (byte b : d.getBytes()) {
                        this.in.write(b);
                    }
                    this.in.flush();
                }
            }
            catch (IOException e) {
                this.closed = true;
                throw e;
            }
            try {
                return this.terminal.dump(10L, forceDump);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.toString());
            }
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            try {
                block2: while (true) {
                    buf = new byte[8192];
                    l = this.out.read(buf);
                    r = new InputStreamReader(new ByteArrayInputStream(buf, 0, l));
                    sb = new StringBuilder();
                    while ((c = r.read()) != -1) {
                        sb.append((char)c);
                    }
                    if (sb.length() > 0) {
                        this.terminal.write(sb.toString());
                    }
                    if ((s = this.terminal.read()) == null || s.length() <= 0) continue;
                    arr$ = s.getBytes();
                    len$ = arr$.length;
                    i$ = 0;
                    while (true) {
                        if (i$ < len$) ** break;
                        continue block2;
                        b = arr$[i$];
                        this.in.write(b);
                        ++i$;
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.closed = true;
                e.printStackTrace();
                return;
            }
        }
    }
}

