/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.servicemix.nmr.core.util.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterIterator<T>
implements Iterator<T> {
    private Iterator<T> iterator;
    private Filter<T> filter;
    private T next;

    public FilterIterator(Iterator<T> iterator, Filter<T> filter) {
        this.iterator = iterator;
        this.filter = filter;
        this.next = this.checkNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        if (this.next != null) {
            T ep = this.next;
            this.next = this.checkNext();
            return ep;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected T checkNext() {
        while (this.iterator.hasNext()) {
            T ep = this.iterator.next();
            if (!this.filter.match(ep)) continue;
            return ep;
        }
        return null;
    }
}

