/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.aries.blueprint.ParserService;
import org.apache.aries.blueprint.annotation.service.BlueprintAnnotationScanner;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.apache.aries.blueprint.container.BlueprintEventDispatcher;
import org.apache.aries.blueprint.container.BlueprintThreadFactory;
import org.apache.aries.blueprint.container.NamespaceHandlerRegistry;
import org.apache.aries.blueprint.container.ParserServiceImpl;
import org.apache.aries.blueprint.namespace.NamespaceHandlerRegistryImpl;
import org.apache.aries.blueprint.utils.HeaderParser;
import org.apache.aries.util.tracker.RecursiveBundleTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintExtender
implements BundleActivator,
SynchronousBundleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlueprintExtender.class);
    private BundleContext context;
    private ScheduledExecutorService executors;
    private Map<Bundle, BlueprintContainerImpl> containers;
    private BlueprintEventDispatcher eventDispatcher;
    private NamespaceHandlerRegistry handlers;
    private RecursiveBundleTracker bt;
    private ServiceRegistration parserServiceReg;

    public void start(BundleContext context) {
        LOGGER.debug("Starting blueprint extender...");
        this.context = context;
        this.handlers = new NamespaceHandlerRegistryImpl(context);
        this.executors = Executors.newScheduledThreadPool(3, new BlueprintThreadFactory("Blueprint Extender"));
        this.eventDispatcher = new BlueprintEventDispatcher(context, this.executors);
        this.containers = new HashMap<Bundle, BlueprintContainerImpl>();
        int stateMask = 62;
        this.bt = new RecursiveBundleTracker(context, stateMask, new BlueprintBundleTrackerCustomizer());
        this.bt.open();
        this.parserServiceReg = context.registerService(ParserService.class.getName(), (Object)new ParserServiceImpl(this.handlers), new Hashtable());
        LOGGER.debug("Blueprint extender started");
    }

    private void checkInitialBundle(Bundle b) {
        String activationPolicyHeader;
        if (b.getState() == 32) {
            this.checkBundle(b);
        } else if (b.getState() == 8 && (activationPolicyHeader = (String)b.getHeaders().get("Bundle-ActivationPolicy")) != null && activationPolicyHeader.startsWith("lazy")) {
            this.checkBundle(b);
        }
    }

    public void stop(BundleContext context) {
        LOGGER.debug("Stopping blueprint extender...");
        if (this.bt != null) {
            this.bt.close();
        }
        this.parserServiceReg.unregister();
        while (!this.containers.isEmpty()) {
            for (Bundle bundle : this.getBundlesToDestroy()) {
                this.destroyContext(bundle);
            }
        }
        this.eventDispatcher.destroy();
        this.handlers.destroy();
        this.executors.shutdown();
        LOGGER.debug("Blueprint extender stopped");
    }

    private List<Bundle> getBundlesToDestroy() {
        ArrayList<Bundle> bundlesToDestroy = new ArrayList<Bundle>();
        for (Bundle bundle : this.containers.keySet()) {
            ServiceReference[] references = bundle.getRegisteredServices();
            int usage = 0;
            if (references != null) {
                for (ServiceReference reference : references) {
                    usage += BlueprintExtender.getServiceUsage(reference);
                }
            }
            LOGGER.debug("Usage for bundle {} is {}", (Object)bundle, (Object)usage);
            if (usage != 0) continue;
            bundlesToDestroy.add(bundle);
        }
        if (!bundlesToDestroy.isEmpty()) {
            Collections.sort(bundlesToDestroy, new Comparator<Bundle>(){

                @Override
                public int compare(Bundle b1, Bundle b2) {
                    return (int)(b2.getLastModified() - b1.getLastModified());
                }
            });
            LOGGER.debug("Selected bundles {} for destroy (no services in use)", bundlesToDestroy);
        } else {
            ServiceReference ref = null;
            for (Bundle bundle : this.containers.keySet()) {
                ServiceReference[] references;
                for (ServiceReference reference : references = bundle.getRegisteredServices()) {
                    if (BlueprintExtender.getServiceUsage(reference) == 0 || ref != null && reference.compareTo(ref) >= 0) continue;
                    LOGGER.debug("Currently selecting bundle {} for destroy (with reference {})", (Object)bundle, (Object)reference);
                    ref = reference;
                }
            }
            bundlesToDestroy.add(ref.getBundle());
            LOGGER.debug("Selected bundle {} for destroy (lowest ranking service)", bundlesToDestroy);
        }
        return bundlesToDestroy;
    }

    private static int getServiceUsage(ServiceReference ref) {
        Bundle[] usingBundles = ref.getUsingBundles();
        return usingBundles != null ? usingBundles.length : 0;
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (event.getType() == 512) {
            this.checkBundle(bundle);
        } else if (event.getType() == 2) {
            BlueprintContainerImpl blueprintContainer = this.containers.get(bundle);
            if (blueprintContainer == null) {
                this.checkBundle(bundle);
            }
        } else if (event.getType() == 256) {
            this.destroyContext(bundle);
        }
    }

    private void destroyContext(Bundle bundle) {
        BlueprintContainerImpl blueprintContainer = this.containers.remove(bundle);
        if (blueprintContainer != null) {
            LOGGER.debug("Destroying BlueprintContainer for bundle {}", (Object)bundle.getSymbolicName());
            blueprintContainer.destroy();
        }
        this.eventDispatcher.removeBlueprintBundle(bundle);
    }

    private void checkBundle(Bundle bundle) {
        LOGGER.debug("Scanning bundle {} for blueprint application", (Object)bundle.getSymbolicName());
        try {
            ArrayList<Object> pathList = new ArrayList<Object>();
            String blueprintHeader = (String)bundle.getHeaders().get("Bundle-Blueprint");
            String blueprintHeaderAnnotation = (String)bundle.getHeaders().get("Bundle-Blueprint-Annotation");
            if (blueprintHeader == null) {
                blueprintHeader = "OSGI-INF/blueprint/";
            }
            List<HeaderParser.PathElement> paths = HeaderParser.parseHeader(blueprintHeader);
            for (HeaderParser.PathElement path : paths) {
                String filePattern;
                String baseName;
                String name = path.getName();
                if (name.endsWith("/")) {
                    this.addEntries(bundle, name, "*.xml", pathList);
                    continue;
                }
                int pos = name.lastIndexOf(47);
                if (pos < 0) {
                    baseName = "/";
                    filePattern = name;
                } else {
                    baseName = name.substring(0, pos + 1);
                    filePattern = name.substring(pos + 1);
                }
                if (this.hasWildcards(filePattern)) {
                    this.addEntries(bundle, baseName, filePattern, pathList);
                    continue;
                }
                this.addEntry(bundle, name, pathList);
            }
            if (pathList.isEmpty() && blueprintHeaderAnnotation != null && blueprintHeaderAnnotation.trim().equalsIgnoreCase("true")) {
                LOGGER.debug("Scanning bundle {} for blueprint annotations", (Object)bundle.getSymbolicName());
                ServiceReference sr = this.context.getServiceReference("org.apache.aries.blueprint.annotation.service.BlueprintAnnotationScanner");
                if (sr != null) {
                    BlueprintAnnotationScanner bas = (BlueprintAnnotationScanner)this.context.getService(sr);
                    URL url = bas.createBlueprintModel(bundle);
                    if (url != null) {
                        pathList.add(url);
                    }
                    this.context.ungetService(sr);
                }
            }
            if (!pathList.isEmpty()) {
                LOGGER.debug("Found blueprint application in bundle {} with paths: {}", (Object)bundle.getSymbolicName(), pathList);
                boolean compatible = this.isCompatible(bundle);
                if (compatible) {
                    BlueprintContainerImpl blueprintContainer = new BlueprintContainerImpl(bundle.getBundleContext(), this.context.getBundle(), this.eventDispatcher, this.handlers, this.executors, pathList);
                    this.containers.put(bundle, blueprintContainer);
                    blueprintContainer.schedule();
                } else {
                    LOGGER.info("Bundle {} is not compatible with this blueprint extender", (Object)bundle.getSymbolicName());
                }
            } else {
                LOGGER.debug("No blueprint application found in bundle {}", (Object)bundle.getSymbolicName());
            }
        }
        catch (Throwable t) {
            this.eventDispatcher.blueprintEvent(new BlueprintEvent(5, bundle, this.context.getBundle(), t));
        }
    }

    private boolean isCompatible(Bundle bundle) {
        boolean compatible;
        if (bundle.getState() == 32) {
            try {
                Class clazz = bundle.getBundleContext().getBundle().loadClass(BlueprintContainer.class.getName());
                compatible = clazz == BlueprintContainer.class;
            }
            catch (ClassNotFoundException e) {
                compatible = true;
            }
        } else {
            compatible = true;
        }
        return compatible;
    }

    private boolean hasWildcards(String path) {
        return path.indexOf("*") >= 0;
    }

    private String getFilePart(URL url) {
        String path = url.getPath();
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    private String cachePath(Bundle bundle, String filePath) {
        return Integer.toHexString(bundle.hashCode()) + "/" + filePath;
    }

    private URL getOverrideURLForCachePath(String privatePath) {
        URL override = null;
        File privateDataVersion = this.context.getDataFile(privatePath);
        if (privateDataVersion != null && privateDataVersion.exists()) {
            try {
                override = privateDataVersion.toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.error("Unexpected URL Conversion Issue", (Throwable)e);
            }
        }
        return override;
    }

    private URL getOverrideURL(Bundle bundle, String path) {
        String cachePath = this.cachePath(bundle, path);
        return this.getOverrideURLForCachePath(cachePath);
    }

    private URL getOverrideURL(Bundle bundle, URL path, String basePath) {
        String cachePath = this.cachePath(bundle, basePath + this.getFilePart(path));
        return this.getOverrideURLForCachePath(cachePath);
    }

    private void addEntry(Bundle bundle, String path, List<Object> pathList) {
        URL override = this.getOverrideURL(bundle, path);
        if (override == null) {
            pathList.add(path);
        } else {
            pathList.add(override);
        }
    }

    private void addEntries(Bundle bundle, String path, String filePattern, List<Object> pathList) {
        Enumeration e = bundle.findEntries(path, filePattern, false);
        while (e != null && e.hasMoreElements()) {
            URL u = (URL)e.nextElement();
            URL override = this.getOverrideURL(bundle, u, path);
            if (override == null) {
                pathList.add(u);
                continue;
            }
            pathList.add(override);
        }
    }

    private class BlueprintBundleTrackerCustomizer
    implements BundleTrackerCustomizer {
        public Object addingBundle(Bundle b, BundleEvent event) {
            if (event == null) {
                BlueprintExtender.this.checkInitialBundle(b);
            } else {
                BlueprintExtender.this.bundleChanged(event);
            }
            return b;
        }

        public void modifiedBundle(Bundle b, BundleEvent event, Object arg2) {
            if (event == null) {
                return;
            }
            BlueprintExtender.this.bundleChanged(event);
        }

        public void removedBundle(Bundle b, BundleEvent event, Object arg2) {
        }
    }
}

